/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;

@Named
@Singleton
public class NugetMaintainAggregateInfo {
    private static final VersionScheme SCHEME = new GenericVersionScheme();

    public void maintainAggregateInfo(Repository repository, Component nugetComponent) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)nugetComponent);
        String packageId = nugetComponent.name();
        TreeSet releases = Sets.newTreeSet((Comparator)new ComponentVersionComparator());
        TreeSet allReleases = Sets.newTreeSet((Comparator)new ComponentVersionComparator());
        NugetContentFacet contentFacet = (NugetContentFacet)repository.facet(NugetContentFacet.class);
        Collection<FluentComponent> versions = contentFacet.findComponents(packageId);
        versions.forEach(component -> component.assets().stream().findFirst().ifPresent(fluentAsset -> {
            Map attributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)fluentAsset);
            boolean isPreRelease = attributes.getOrDefault("is_prerelease", false);
            if (!isPreRelease) {
                releases.add(component);
            }
            allReleases.add(component);
        }));
        FluentComponent latestVersion = releases.isEmpty() ? null : (FluentComponent)releases.last();
        FluentComponent absoluteLatestVersion = allReleases.isEmpty() ? null : (FluentComponent)allReleases.last();
        allReleases.forEach(component -> component.assets().stream().findFirst().ifPresent(fluentAsset -> {
            Map attributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)fluentAsset);
            boolean latest = component.equals(latestVersion);
            boolean absoluteLatest = component.equals(absoluteLatestVersion);
            boolean needsUpdate = false;
            if (this.isAttributeChanged("is_latest_version", attributes, latest)) {
                attributes.put("is_latest_version", latest);
                needsUpdate = true;
            }
            if (this.isAttributeChanged("is_absolute_latest_version", attributes, absoluteLatest)) {
                attributes.put("is_absolute_latest_version", absoluteLatest);
                needsUpdate = true;
            }
            if (needsUpdate) {
                fluentAsset.attributes(AttributeOperation.OVERLAY, "nuget", (Object)attributes);
            }
        }));
    }

    public boolean isPreRelease(String version) {
        int prereleaseIdx = version.indexOf(45);
        int metadataIdx = version.indexOf(43);
        return prereleaseIdx > 0 && (metadataIdx == -1 || prereleaseIdx < metadataIdx);
    }

    private boolean isAttributeChanged(String key, Map<String, Object> attributes, boolean current) {
        Object value = attributes.get(key);
        return !(value instanceof Boolean) || (Boolean)value != current;
    }

    private static class ComponentVersionComparator
    implements Comparator<FluentComponent> {
        private ComponentVersionComparator() {
        }

        @Override
        public int compare(FluentComponent o1, FluentComponent o2) {
            try {
                Version v1 = SCHEME.parseVersion(o1.version());
                Version v2 = SCHEME.parseVersion(o2.version());
                return v1.compareTo((Object)v2);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

