/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetMaintainAggregateInfo;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.maintenance.SingleAssetMaintenanceFacet;

@Named
public class NugetContentMaintenanceFacet
extends SingleAssetMaintenanceFacet {
    private final NugetMaintainAggregateInfo nugetMaintainAggregateInfo;

    @Inject
    public NugetContentMaintenanceFacet(NugetMaintainAggregateInfo nugetMaintainAggregateInfo) {
        this.nugetMaintainAggregateInfo = (NugetMaintainAggregateInfo)Preconditions.checkNotNull((Object)nugetMaintainAggregateInfo);
    }

    public Set<String> deleteComponent(Component component) {
        Set deletedPaths = super.deleteComponent(component);
        this.nugetMaintainAggregateInfo.maintainAggregateInfo(this.getRepository(), component);
        return deletedPaths;
    }

    public Set<String> deleteAsset(Asset asset) {
        Set deletedPaths = super.deleteAsset(asset);
        asset.component().ifPresent(component -> this.nugetMaintainAggregateInfo.maintainAggregateInfo(this.getRepository(), (Component)component));
        return deletedPaths;
    }
}

