/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.datastore.NugetAssetUtils;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetMaintainAggregateInfo;
import com.sonatype.nexus.repository.nuget.datastore.store.NugetComponentStore;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.odata4j.core.ImmutableMap;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="nuget")
public class NugetContentFacetImpl
extends ContentFacetSupport
implements NugetContentFacet {
    private final NugetMaintainAggregateInfo nugetMaintainAggregateInfo;

    @Inject
    protected NugetContentFacetImpl(@Named(value="nuget") FormatStoreManager formatStoreManager, NugetMaintainAggregateInfo nugetMaintainAggregateInfo) {
        super(formatStoreManager);
        this.nugetMaintainAggregateInfo = (NugetMaintainAggregateInfo)Preconditions.checkNotNull((Object)nugetMaintainAggregateInfo);
    }

    @Override
    public Optional<Content> get(String packageId, String version) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        return this.findAsset(packageId, version).map(FluentAsset::download);
    }

    @Override
    public FluentAsset putPackage(String packageId, String version, Payload payload) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.blobs().ingest(payload, NugetPackageUtils.HASH_ALGORITHMS);){
            ImmutableMap formatAttributes = ImmutableMap.of((Object)"id", (Object)packageId, (Object)"version", (Object)version);
            Map<String, Object> assetAttributes = Collections.singletonMap("is_prerelease", this.nugetMaintainAggregateInfo.isPreRelease(version));
            FluentAsset asset = this.putPackage(packageId, version, blob, (Map<String, String>)formatAttributes, assetAttributes);
            return asset.markAsCached(payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public FluentAsset putPackage(String packageId, String version, TempBlob tempBlob, Map<String, String> componentAttributes, Map<String, Object> assetAttributes) {
        FluentComponent component = this.getOrCreateComponent(packageId, version, componentAttributes);
        String assetName = new NugetPackageCoords(component.name(), component.version()).toPath();
        FluentAsset asset = this.getOrCreatePackageAsset(assetName, component, assetAttributes, tempBlob);
        this.nugetMaintainAggregateInfo.maintainAggregateInfo(this.repository(), (Component)component);
        return asset;
    }

    @Override
    public FluentAsset putHardlinkPackage(String packageId, String version, Blob assetBlob, Map<String, String> componentAttributes, Map<String, Object> assetAttributes, Map<HashAlgorithm, HashCode> checksums) {
        FluentComponent component = this.getOrCreateComponent(packageId, version, componentAttributes);
        String assetName = new NugetPackageCoords(component.name(), component.version()).toPath();
        FluentAsset asset = this.hardlinkCreateAsset(assetName, component, assetAttributes, assetBlob, checksums);
        this.nugetMaintainAggregateInfo.maintainAggregateInfo(this.repository(), (Component)component);
        return asset;
    }

    @Override
    public FluentAsset putMetadata(String assetPath, Payload payload) {
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)assetPath);
        this.setContentLastModified(payload);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, NugetPackageUtils.HASH_ALGORITHMS);){
            return this.assets().path(assetPath).blob(tempBlob).save().markAsCached(payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean delete(String packageId, String version) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        ContentMaintenanceFacet maintenanceFacet = (ContentMaintenanceFacet)this.getRepository().facet(ContentMaintenanceFacet.class);
        return this.findComponent(packageId, version).map(arg_0 -> ((ContentMaintenanceFacet)maintenanceFacet).deleteComponent(arg_0)).map(deletedPaths -> !deletedPaths.isEmpty()).orElse(Boolean.FALSE);
    }

    public List<FluentComponent> findComponents(String packageId) {
        Preconditions.checkNotNull((Object)packageId);
        NugetComponentStore nugetComponentStore = (NugetComponentStore)this.stores().componentStore;
        return nugetComponentStore.findComponentsCaseInsensitive(this.getRepository(), packageId).stream().map(component -> this.components().with(component)).collect(Collectors.toList());
    }

    @Override
    public Optional<FluentComponent> findComponent(String packageId, String version) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        NugetComponentStore nugetComponentStore = (NugetComponentStore)this.stores().componentStore;
        return nugetComponentStore.findComponentsCaseInsensitive(this.getRepository(), packageId, version).stream().map(component -> this.components().with(component)).findAny();
    }

    @Override
    public Optional<FluentAsset> findAsset(String packageId, String version) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        return this.findComponent(packageId, version).map(FluentComponent::assets).map(Collection::stream).flatMap(Stream::findFirst);
    }

    @Override
    public Optional<FluentAsset> findAsset(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        return this.assets().path(assetPath).find();
    }

    @Override
    public Optional<Content> getServiceIndex() {
        return this.assets().path("/index.json").find().map(FluentAsset::download);
    }

    private void setContentLastModified(Payload payload) {
        if (payload instanceof Content) {
            Content content = (Content)payload;
            NugetAssetUtils.setLastModified(content);
        }
    }

    private FluentComponent getOrCreateComponent(String packageId, String version, Map<String, String> componentAttributes) {
        return this.components().name(packageId).version(version).attributes("nuget", componentAttributes).getOrCreate();
    }

    private FluentAsset hardlinkCreateAsset(String name, FluentComponent component, Map<String, Object> attributes, Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        return this.assets().path(name).component((Component)component).attributes("nuget", attributes).blob(blob, checksums).save();
    }

    private FluentAsset getOrCreatePackageAsset(String name, FluentComponent component, Map<String, Object> attributes, TempBlob tempBlob) {
        return component.assets().stream().findFirst().map(existingAsset -> ((FluentAsset)existingAsset.attributes(AttributeOperation.OVERLAY, "nuget", (Object)attributes)).attach(tempBlob)).orElseGet(() -> this.assets().path(name).component((Component)component).blob(tempBlob).attributes("nuget", (Object)attributes).save());
    }
}

