/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.browse.node.BrowsePathBuilder;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.DefaultBrowseNodeGenerator;

@Singleton
@Named(value="nuget")
public class NugetBrowseNodeGenerator
extends DefaultBrowseNodeGenerator {
    public List<BrowsePath> computeAssetPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        if (!asset.hasBlob()) {
            return Collections.emptyList();
        }
        Optional componentOpt = asset.component();
        if (componentOpt.isPresent()) {
            Component component = (Component)componentOpt.get();
            List<BrowsePath> paths = this.computeComponentPaths(asset);
            String packageName = NugetBrowseNodeGenerator.packageName(component.name(), component.version());
            BrowsePathBuilder.appendPath(paths, (String)packageName);
            return paths;
        }
        List paths = super.computeAssetPaths(asset);
        if (paths.size() == 2 && Character.isDigit(((BrowsePath)paths.get(1)).getDisplayName().charAt(0))) {
            String requestPath = StringUtils.appendIfMissing((String)((BrowsePath)paths.get(1)).getRequestPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            ((BrowsePath)paths.get(1)).setRequestPath(requestPath);
            String packageName = NugetBrowseNodeGenerator.packageName(((BrowsePath)paths.get(0)).getDisplayName(), ((BrowsePath)paths.get(1)).getDisplayName());
            BrowsePathBuilder.appendPath((List)paths, (String)packageName);
        }
        return paths;
    }

    public List<BrowsePath> computeComponentPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        Optional componentOpt = asset.component();
        if (!asset.hasBlob() || !componentOpt.isPresent()) {
            return Collections.emptyList();
        }
        Component component = (Component)componentOpt.get();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(component.name());
        if (StringUtils.isNotBlank((CharSequence)component.version())) {
            paths.add(component.version());
        }
        return BrowsePathBuilder.fromPaths(paths, (boolean)true);
    }

    private static String packageName(String id, @Nullable String version) {
        return StringUtils.isNotBlank((CharSequence)version) ? String.format("%s-%s.nupkg", id, version) : String.format("%s.nupkg", id);
    }
}

