/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.datastore.ContentNugetV3HostedFacet;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.internal.NugetUploadHandlerSupport;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.utils.HardLinkHelper;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="nuget")
@Singleton
public class NugetUploadHandler
extends NugetUploadHandlerSupport {
    private final HardLinkHelper hardLinkHelper;
    private final HashAlgorithmHelper hashAlgorithmHelper;

    @Inject
    public NugetUploadHandler(ContentPermissionChecker contentPermissionCheckerr, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions, HardLinkHelper hardLinkHelper, HashAlgorithmHelper hashAlgorithmHelper) {
        super(contentPermissionCheckerr, variableResolverAdapter, uploadDefinitionExtensions);
        this.hardLinkHelper = (HardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
    }

    public UploadResponse handle(Repository repository, ComponentUpload componentUpload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)componentUpload);
        PartPayload payload = ((AssetUpload)componentUpload.getAssetUploads().get(0)).getPayload();
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (TempBlob tempBlob = contentFacet.blobs().ingest((Payload)payload, NugetPackageUtils.HASH_ALGORITHMS);){
                Map<String, String> metadata = this.getMetadata(tempBlob);
                NugetPackageCoords nugetPackageCoords = this.getNugetPackageCoords(repository, metadata);
                ContentNugetV3HostedFacet hostedFacet = (ContentNugetV3HostedFacet)repository.facet(ContentNugetV3HostedFacet.class);
                Content content = hostedFacet.put(metadata, tempBlob);
                this.log.debug("Added nuget component {}", (Object)nugetPackageCoords);
                return new UploadResponse(content, Collections.singletonList(nugetPackageCoords.toString()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NugetPackageException e) {
            throw new IOException("Unable to get valid component from supplied file", e);
        }
    }

    public Content handle(Repository repository, File file, String path) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)path);
        return this.handle(new ImportFileConfiguration(repository, file, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        Preconditions.checkNotNull((Object)configuration);
        if (NugetPackageUtils.isV3Metadata(configuration.getFile().getName())) {
            this.log.trace("Skipping {} as we only care about NuGet packages.", (Object)configuration.getFile().getName());
            return null;
        }
        if (configuration.isHardLinkingEnabled()) {
            return this.handleHardlinkImport(configuration);
        }
        return this.handleImport(configuration);
    }

    private Content handleHardlinkImport(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        File file = configuration.getFile();
        ContentNugetV3HostedFacet hostedFacet = (ContentNugetV3HostedFacet)repository.facet(ContentNugetV3HostedFacet.class);
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(file, NugetPackageUtils.HASH_ALGORITHMS);
        HashCode sha1HashCode = (HashCode)checksums.get(HashAlgorithm.SHA1);
        Blob hardLinkingBlob = this.hardLinkHelper.ingestHardLink(repository, file, sha1HashCode);
        try {
            Map<String, String> metadata = this.getMetadata(hardLinkingBlob);
            return hostedFacet.hardLinkPut(metadata, hardLinkingBlob, checksums);
        }
        catch (NugetPackageException e) {
            throw new IOException("Unable to get valid component from supplied file", e);
        }
    }

    private Content handleImport(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        File file = configuration.getFile();
        NugetContentFacet contentFacet = (NugetContentFacet)repository.facet(NugetContentFacet.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (TempBlob tempBlob = contentFacet.blobs().ingest(Files.newInputStream(file.toPath(), new OpenOption[0]), null, NugetPackageUtils.HASH_ALGORITHMS);){
                Map<String, String> metadata = this.getMetadata(tempBlob);
                NugetPackageCoords nugetPackageCoords = this.getNugetPackageCoords(repository, metadata);
                ContentNugetV3HostedFacet hostedFacet = (ContentNugetV3HostedFacet)repository.facet(ContentNugetV3HostedFacet.class);
                Content content = hostedFacet.put(metadata, tempBlob);
                this.log.debug("Added nuget component {}", (Object)nugetPackageCoords);
                return content;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NugetPackageException e) {
            throw new IOException("Unable to get valid component from supplied file", e);
        }
    }

    public boolean supportsExportImport() {
        return true;
    }

    private NugetPackageCoords getNugetPackageCoords(Repository repository, Map<String, String> metadata) {
        NugetPackageCoords nugetPackageCoords = new NugetPackageCoords(metadata.get("ID"), metadata.get("VERSION"));
        String path = String.valueOf(nugetPackageCoords.getId()) + "/" + nugetPackageCoords.getVersion();
        this.ensurePermitted(repository.getName(), "nuget", path, this.toMap(nugetPackageCoords));
        return nugetPackageCoords;
    }
}

