/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetContentMatcher;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public class NugetAssetUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String SERVICE_INDEX_ASSET_PATH = "/index.json";

    private NugetAssetUtils() {
    }

    public static <T> T serialize(Payload payload, Class<T> clazz) throws IOException {
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull(clazz);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = payload.openInputStream();){
            return (T)OBJECT_MAPPER.readValue(inputStream, clazz);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Content asJsonContent(Object object) throws JsonProcessingException {
        Preconditions.checkNotNull((Object)object);
        String json = OBJECT_MAPPER.writeValueAsString(object);
        StringPayload payload = new StringPayload(json, "application/json");
        return new Content((Payload)payload);
    }

    public static void copyAttributes(Content fromContent, Content toContent) {
        toContent.getAttributes().backing().putAll(fromContent.getAttributes().backing());
    }

    public static String assetName(Context context) {
        switch ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))) {
            case SERVICE_INDEX: {
                return SERVICE_INDEX_ASSET_PATH;
            }
            case CONTENT: {
                return StringUtils.prependIfMissing((String)NugetV3ProxyUtil.joinPath(NugetContentMatcher.getContentPackageId(context), NugetContentMatcher.getContentVersion(context)), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            }
        }
        return StringUtils.prependIfMissing((String)NugetV3ProxyUtil.trimSlashes(context.getRequest().getPath()), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    public static void setLastModified(Content content) {
        if (!content.getAttributes().contains("last_modified")) {
            content.getAttributes().set("last_modified", (Object)ODataFeedUtils.datetime(DateTime.now().getMillis()));
        }
    }
}

