/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.swagger.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.Reader;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.rest.Component;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.swagger.SwaggerContributor;

@Named
@Singleton
public class SwaggerModel
implements Component {
    private final ApplicationVersion applicationVersion;
    private final Reader reader;
    private final List<SwaggerContributor> contributors;

    @Inject
    public SwaggerModel(ApplicationVersion applicationVersion, List<SwaggerContributor> contributors) {
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
        this.contributors = (List)Preconditions.checkNotNull(contributors);
        ModelConverters.getInstance().addConverter((ModelConverter)new ModelFilter());
        this.reader = new Reader(this.createSwagger());
    }

    public void scan(Class<Resource> resourceClass) {
        this.reader.read(resourceClass);
        this.contributors.forEach(c -> c.contribute(this.getSwagger()));
    }

    public Swagger getSwagger() {
        return this.reader.getSwagger();
    }

    private Swagger createSwagger() {
        return new Swagger().info(new Info().title("Nexus Repository Manager REST API").version(this.applicationVersion.getVersion()));
    }

    private static class ModelFilter
    implements ModelConverter {
        private static final Set<String> BANNED_TYPE_NAMES = ImmutableSet.of((Object)"[simple type, class groovy.lang.MetaClass]");

        private ModelFilter() {
        }

        public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
            if (!BANNED_TYPE_NAMES.contains(type.getTypeName()) && chain.hasNext()) {
                return chain.next().resolve(type, context, chain);
            }
            return null;
        }

        public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
            if (!BANNED_TYPE_NAMES.contains(type.getTypeName()) && chain.hasNext()) {
                return chain.next().resolveProperty(type, context, annotations, chain);
            }
            return null;
        }
    }
}

