/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.formfields;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.Combobox;

public class RepositoryCombobox
extends Combobox<String> {
    private List<String> includingTypes;
    private List<String> excludingTypes;
    private boolean regardlessViewPermissions;
    private List<String> includingFormats;
    private List<String> excludingFormats;
    private List<String> includingVersionPolicies;
    private List<String> excludingVersionPolicies;
    private List<String> includingFacets;
    private boolean generateAllRepositoriesEntry;
    private boolean includeEntriesForAllFormats;
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    public RepositoryCombobox(String id, String label, String helpText, boolean required, String regexValidation) {
        super(id, label, helpText, required, regexValidation);
    }

    public RepositoryCombobox(String id, String label, String helpText, boolean required) {
        super(id, label, helpText, required);
    }

    public RepositoryCombobox(String id, boolean required) {
        super(id, messages.label(), messages.helpText(), required);
    }

    public RepositoryCombobox(String id) {
        super(id, messages.label(), messages.helpText(), false);
    }

    public RepositoryCombobox includingAnyOfTypes(String ... types) {
        this.includingTypes = Arrays.asList(types);
        return this;
    }

    public RepositoryCombobox excludingAnyOfTypes(String ... types) {
        this.excludingTypes = Arrays.asList(types);
        return this;
    }

    public RepositoryCombobox includingAnyOfFormats(String ... formats) {
        this.includingFormats = Arrays.asList(formats);
        return this;
    }

    public RepositoryCombobox excludingAnyOfFormats(String ... formats) {
        this.excludingFormats = Arrays.asList(formats);
        return this;
    }

    public RepositoryCombobox includingAnyOfVersionPolicies(String ... versionPolicies) {
        this.includingVersionPolicies = Arrays.asList(versionPolicies);
        return this;
    }

    public RepositoryCombobox excludingAnyOfVersionPolicies(String ... versionPolicies) {
        this.excludingVersionPolicies = Arrays.asList(versionPolicies);
        return this;
    }

    public RepositoryCombobox includingAnyOfFacets(Class<?> ... facets) {
        this.includingFacets = Lists.transform(Arrays.asList(facets), Class::getName);
        return this;
    }

    public RepositoryCombobox regardlessViewPermissions() {
        this.regardlessViewPermissions = true;
        return this;
    }

    public RepositoryCombobox includeAnEntryForAllRepositories() {
        this.generateAllRepositoriesEntry = true;
        return this;
    }

    public RepositoryCombobox includeEntriesForAllFormats() {
        this.includeEntriesForAllFormats = true;
        return this;
    }

    @Override
    public boolean getAllowAutocomplete() {
        return true;
    }

    @Override
    public String getStoreApi() {
        String method = "readReferences";
        if (this.includeEntriesForAllFormats) {
            method = "readReferencesAddingEntriesForAllFormats";
        } else if (this.generateAllRepositoriesEntry) {
            method = "readReferencesAddingEntryForAll";
        }
        return "coreui_Repository." + method;
    }

    @Override
    public Map<String, String> getStoreFilters() {
        HashMap storeFilters = Maps.newHashMap();
        StringBuilder types = new StringBuilder();
        if (this.includingTypes != null) {
            for (String type : this.includingTypes) {
                if (types.length() > 0) {
                    types.append(',');
                }
                types.append(type);
            }
        }
        if (this.excludingTypes != null) {
            for (String type : this.excludingTypes) {
                if (types.length() > 0) {
                    types.append(',');
                }
                types.append('!').append(type);
            }
        }
        if (types.length() > 0) {
            storeFilters.put("type", types.toString());
        }
        StringBuilder contentClasses = new StringBuilder();
        if (this.includingFormats != null) {
            for (String format : this.includingFormats) {
                if (contentClasses.length() > 0) {
                    contentClasses.append(',');
                }
                contentClasses.append(format);
            }
        }
        if (this.excludingFormats != null) {
            for (String format : this.excludingFormats) {
                if (contentClasses.length() > 0) {
                    contentClasses.append(',');
                }
                contentClasses.append("!").append(format);
            }
        }
        String versionPolicies = this.getVersionPolicies();
        if (contentClasses.length() > 0) {
            storeFilters.put("format", contentClasses.toString());
        }
        if (this.includingFacets != null) {
            storeFilters.put("facets", Joiner.on((char)',').join(this.includingFacets));
        }
        if (this.regardlessViewPermissions) {
            storeFilters.put("regardlessViewPermissions", "true");
        }
        if (versionPolicies.length() > 0) {
            storeFilters.put("versionPolicies", versionPolicies);
        }
        return storeFilters.isEmpty() ? null : storeFilters;
    }

    private String getVersionPolicies() {
        return Stream.concat(Optional.ofNullable(this.includingVersionPolicies).orElse(Collections.emptyList()).stream(), Optional.ofNullable(this.excludingVersionPolicies).orElse(Collections.emptyList()).stream().map(s -> "!" + s)).collect(Collectors.joining(","));
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository")
        public String label();

        @MessageBundle.DefaultMessage(value="Select the repository.")
        public String helpText();
    }
}

