/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.rest;

import com.sonatype.nexus.repository.npm.rest.NpmAttributes;
import com.sonatype.nexus.repository.npm.rest.NpmProxyApiRepository;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named(value="npm")
public class NpmApiRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    @Inject
    public NpmApiRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public AbstractApiRepository adapt(Repository repository) {
        if ("proxy".equals(repository.getType().toString())) {
            return new NpmProxyApiRepository(repository.getName(), repository.getUrl(), repository.getConfiguration().isOnline(), (StorageAttributes)this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.createNpmAttributes(repository), this.getReplicationAttributes(repository));
        }
        return super.adapt(repository);
    }

    private NpmAttributes createNpmAttributes(Repository repository) {
        Boolean removeNonCataloged = (Boolean)repository.getConfiguration().attributes("npm").get("removeNonCataloged", Boolean.class, (Object)Boolean.FALSE);
        Boolean removeQuarantined = (Boolean)repository.getConfiguration().attributes("npm").get("removeQuarantinedVersions", Boolean.class, (Object)Boolean.FALSE);
        return new NpmAttributes(removeNonCataloged, removeQuarantined);
    }
}

