/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.repair.orient;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import com.sonatype.nexus.repository.npm.internal.orient.NpmPackageRootMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.orient.OrientNpmHostedFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.common.Strings;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.Hashes;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.repair.RepairMetadataComponent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class NpmRepairPackageRootComponent
extends RepairMetadataComponent {
    private static final String SHASUM = "shasum";
    private static final String DIST = "dist";
    private static final String VERSIONS = "versions";
    private static final String INTEGRITY = "integrity";
    private final NpmPackageParser npmPackageParser;

    @Inject
    public NpmRepairPackageRootComponent(RepositoryManager repositoryManager, AssetEntityAdapter assetEntityAdapter, NpmPackageParser npmPackageParser, @Named(value="hosted") Type hostedType, @Named(value="npm") Format npmFormat) {
        super(repositoryManager, assetEntityAdapter, hostedType, npmFormat);
        this.npmPackageParser = (NpmPackageParser)((Object)Preconditions.checkNotNull((Object)((Object)npmPackageParser)));
    }

    public void repair() {
        this.log.info("Beginning processing all npm packages for repair");
        StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(arg_0 -> ((NpmRepairPackageRootComponent)this).shouldRepairRepository(arg_0)).forEach(arg_0 -> ((NpmRepairPackageRootComponent)this).doRepairRepository(arg_0));
    }

    public void updateAsset(Repository repository, StorageTx tx, Asset asset) {
        Blob blob;
        if (NpmAttributes.AssetKind.TARBALL.name().equals(asset.formatAttributes().get("asset_kind")) && (blob = tx.getBlob(asset.blobRef())) != null) {
            this.maybeUpdateAsset(repository, asset, blob);
        }
    }

    private void maybeUpdateAsset(Repository repository, Asset asset, Blob blob) {
        try {
            Map<String, Object> packageJson = this.npmPackageParser.parsePackageJson(() -> ((Blob)blob).getInputStream());
            NestedAttributesMap updatedMetadata = NpmPackageRootMetadataUtils.createFullPackageMetadata(new NestedAttributesMap("metadata", packageJson), repository.getName(), blob.getMetrics().getSha1Hash(), repository, NpmVersionComparator.extractPackageRootVersionUnlessEmpty);
            this.updatePackageRootIfShaIncorrect(repository, asset, blob, updatedMetadata, NpmPackageId.parse((String)packageJson.get("name")), (String)packageJson.get("version"));
        }
        catch (Exception e) {
            this.log.error("Failed to update asset {} in repository {}", new Object[]{asset.name(), repository.getName(), e});
        }
    }

    private void updatePackageRootIfShaIncorrect(Repository repository, Asset asset, Blob blob, NestedAttributesMap newPackageRoot, NpmPackageId packageId, String packageVersion) {
        OrientNpmHostedFacet hostedFacet = (OrientNpmHostedFacet)repository.facet(OrientNpmHostedFacet.class);
        try {
            String newSha;
            String oldSha;
            NestedAttributesMap oldPackageRoot = NpmPackageRootMetadataUtils.getPackageRoot((StorageTx)UnitOfWork.currentTx(), repository, packageId);
            if (oldPackageRoot != null && !Objects.equals(oldSha = this.extractShasum(oldPackageRoot, packageVersion), newSha = this.extractShasum(newPackageRoot, packageVersion))) {
                this.maybeUpdateIntegrity(asset, blob, packageVersion, oldPackageRoot, newPackageRoot);
                hostedFacet.putPackageRoot(packageId, null, newPackageRoot);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to update asset {}", (Object)asset.name(), (Object)e);
        }
    }

    private String extractShasum(NestedAttributesMap oldPackageRoot, String packageVersion) {
        return (String)this.getDist(packageVersion, oldPackageRoot).get(SHASUM, String.class);
    }

    private void maybeUpdateIntegrity(Asset asset, Blob blob, String packageVersion, NestedAttributesMap oldPackageRoot, NestedAttributesMap metadata) {
        String incorrectIntegrity = (String)this.getDist(packageVersion, oldPackageRoot).get(INTEGRITY, String.class);
        if (!Strings.isNullOrEmpty((String)incorrectIntegrity)) {
            String algorithm = incorrectIntegrity.split("-")[0];
            this.getDist(packageVersion, metadata).set(INTEGRITY, (Object)this.calculateIntegrity(asset, blob, algorithm));
        }
    }

    private NestedAttributesMap getDist(String packageVersion, NestedAttributesMap packageRoot) {
        return packageRoot.child(VERSIONS).child(packageVersion).child(DIST);
    }

    private String calculateIntegrity(Asset asset, Blob blob, String algorithm) {
        try {
            HashCode hash = algorithm.equalsIgnoreCase(HashAlgorithm.SHA1.name()) ? Hashes.hash((HashAlgorithm)HashAlgorithm.SHA1, (InputStream)blob.getInputStream()) : Hashes.hash((HashAlgorithm)HashAlgorithm.SHA512, (InputStream)blob.getInputStream());
            return String.valueOf(algorithm) + "-" + Base64.getEncoder().encodeToString(hash.asBytes());
        }
        catch (IOException e) {
            this.log.error("Failed to calculate hash for asset {}", (Object)asset.name(), (Object)e);
            return "";
        }
    }
}

