/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.orient.internal.search.legacy;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Closer;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFacet;
import com.sonatype.nexus.repository.npm.orient.internal.search.legacy.NpmSearchIndexFacetCaching;
import com.sonatype.nexus.repository.npm.orient.internal.search.legacy.NpmSearchIndexInvalidatedEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.storage.AssetManager;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Deprecated
@Named
public class NpmSearchIndexFacetGroup
extends NpmSearchIndexFacetCaching
implements EventAware.Asynchronous {
    @Inject
    public NpmSearchIndexFacetGroup(EventManager eventManager, AssetManager assetManager) {
        super(eventManager, assetManager);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(NpmSearchIndexInvalidatedEvent event) {
        if (((GroupFacet)this.facet(GroupFacet.class)).member(event.getRepository())) {
            this.invalidateCachedSearchIndex();
        }
    }

    @Override
    @Nonnull
    protected Content buildIndex(StorageTx tx, Path path) throws IOException {
        List members = ((GroupFacet)this.facet(GroupFacet.class)).leafMembers();
        try (Closer closer = Closer.create();){
            try {
                ArrayList<JsonParser> parsers = new ArrayList<JsonParser>(members.size());
                this.pauseTransactionAndProcessMemberRepositories(tx, members, closer, parsers);
                JsonGenerator generator = (JsonGenerator)closer.register((Closeable)NpmJsonUtils.mapper.getFactory().createGenerator((OutputStream)new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]))));
                generator.writeStartObject();
                generator.writeNumberField("_updated", System.currentTimeMillis());
                PackageMerger packageMerger = new PackageMerger(parsers);
                while (!packageMerger.isDepleted()) {
                    NestedAttributesMap packageRoot = packageMerger.next();
                    generator.writeObjectField(packageRoot.getKey(), (Object)packageRoot.backing());
                }
                generator.writeEndObject();
                generator.flush();
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
        }
        return new Content((Payload)new StreamPayload(() -> new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), Files.size(path), "application/json"));
    }

    private void pauseTransactionAndProcessMemberRepositories(StorageTx tx, List<Repository> members, Closer closer, ArrayList<JsonParser> parsers) throws IOException {
        UnitOfWork groupWork = UnitOfWork.pause();
        try {
            tx.commit();
            for (Repository repository : Lists.reverse(members)) {
                this.processMember(closer, parsers, repository);
            }
        }
        finally {
            UnitOfWork.resume((UnitOfWork)groupWork);
            tx.begin();
        }
    }

    private void processMember(Closer closer, ArrayList<JsonParser> parsers, Repository repository) throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            Content index = ((NpmSearchIndexFacet)repository.facet(NpmSearchIndexFacet.class)).searchIndex(null);
            JsonParser jsonParser = NpmJsonUtils.mapper.getFactory().createParser((InputStream)closer.register((Closeable)index.openInputStream()));
            closer.register((Closeable)jsonParser);
            if (jsonParser.nextToken() == JsonToken.START_OBJECT && "_updated".equals(jsonParser.nextFieldName())) {
                jsonParser.nextValue();
                parsers.add(jsonParser);
            }
        }
        finally {
            UnitOfWork.end();
        }
    }

    private static class PackageMerger {
        private final List<JsonParser> parsers;
        private final TreeMap<String, NestedAttributesMap> nextPackages;
        private final Multimap<String, JsonParser> origins;

        public PackageMerger(List<JsonParser> parsers) throws IOException {
            this.parsers = parsers;
            this.nextPackages = new TreeMap();
            this.origins = ArrayListMultimap.create();
            Iterator<JsonParser> parserIterator = parsers.iterator();
            while (parserIterator.hasNext()) {
                JsonParser parser = parserIterator.next();
                if (this.tryNext(parser)) continue;
                parserIterator.remove();
            }
        }

        public boolean isDepleted() {
            return this.nextPackages.isEmpty();
        }

        public NestedAttributesMap next() throws IOException {
            String nextKey = this.nextPackages.firstKey();
            NestedAttributesMap next = this.nextPackages.remove(nextKey);
            Collection nextKeyOrigins = this.origins.removeAll((Object)nextKey);
            for (JsonParser origin : nextKeyOrigins) {
                if (this.tryNext(origin)) continue;
                this.parsers.remove(origin);
            }
            return next;
        }

        private boolean tryNext(JsonParser origin) throws IOException {
            String packageName = origin.nextFieldName();
            if (packageName == null) {
                return false;
            }
            origin.nextToken();
            NestedAttributesMap packageRoot = new NestedAttributesMap(packageName, (Map)origin.readValueAs(NpmJsonUtils.rawMapJsonTypeRef));
            if (this.nextPackages.containsKey(packageName)) {
                packageRoot = NpmMetadataUtils.merge(packageName, (List<NestedAttributesMap>)ImmutableList.of((Object)this.nextPackages.get(packageName), (Object)packageRoot));
                NpmMetadataUtils.shrink(packageRoot);
            }
            this.nextPackages.put(packageName, packageRoot);
            this.origins.put((Object)packageName, (Object)origin);
            return true;
        }
    }
}

