/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.orient.internal.search.legacy;

import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFacet;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFilter;
import com.sonatype.nexus.repository.npm.orient.internal.search.legacy.NpmSearchIndexInvalidatedEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetManager;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Deprecated
public abstract class NpmSearchIndexFacetCaching
extends FacetSupport
implements NpmSearchIndexFacet {
    private final EventManager eventManager;
    private final AssetManager assetManager;

    protected NpmSearchIndexFacetCaching(EventManager eventManager, AssetManager assetManager) {
        this.eventManager = eventManager;
        this.assetManager = assetManager;
    }

    @Override
    @Nonnull
    public Content searchIndex(@Nullable DateTime since) throws IOException {
        Content searchIndex = this.getCachedSearchIndex();
        if (searchIndex == null) {
            searchIndex = this.getSearchIndex();
        }
        return NpmSearchIndexFilter.filterModifiedSince(searchIndex, since);
    }

    @Nullable
    @TransactionalTouchBlob
    protected Content getCachedSearchIndex() throws IOException {
        return this.getSearchIndex(true);
    }

    @TransactionalStoreBlob
    protected Content getSearchIndex() throws IOException {
        return this.getSearchIndex(false);
    }

    @Nullable
    private Content getSearchIndex(boolean fromCacheOnly) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            if (fromCacheOnly) {
                return null;
            }
            this.log.debug("Building npm index for {}", (Object)this.getRepository().getName());
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name("-/all");
            Path path = Files.createTempFile("npm-searchIndex", "json", new FileAttribute[0]);
            try {
                Content content;
                block16: {
                    Throwable throwable = null;
                    Object var7_8 = null;
                    Content content2 = this.buildIndex(tx, path);
                    try {
                        content = NpmFacetUtils.saveRepositoryRoot(tx, asset, () -> ((Content)content2).openInputStream(), content2);
                        if (content2 == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (content2 != null) {
                                content2.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    content2.close();
                }
                return content;
            }
            finally {
                Files.delete(path);
            }
        }
        if (this.assetManager.maybeUpdateLastDownloaded(asset)) {
            tx.saveAsset(asset);
        }
        return NpmFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    public void invalidateCachedSearchIndex() {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            try {
                this.deleteAsset();
            }
            catch (IOException e) {
                this.log.warn("Could not invalidate cached search index for {}", (Object)this.getRepository().getName(), (Object)e);
                UnitOfWork.end();
            }
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected void deleteAsset() throws IOException {
        this.log.debug("Invalidating cached npm index of {}", (Object)this.getRepository().getName());
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return;
        }
        tx.deleteAsset(asset);
        this.eventManager.post((Object)new NpmSearchIndexInvalidatedEvent(this.getRepository()));
    }

    @Nonnull
    protected abstract Content buildIndex(StorageTx var1, Path var2) throws IOException;
}

