/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.tasks.orient;

import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import com.sonatype.nexus.repository.npm.internal.tasks.BaseRebuildNpmMetadataTask;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRebuildNpmMetadataTask
extends BaseRebuildNpmMetadataTask {
    private static final String ATTRIBUTES_NPM_ASSET_KIND = "attributes.npm.asset_kind";

    @Inject
    public OrientRebuildNpmMetadataTask(@Named(value="hosted") Type hostedType, @Named(value="npm") Format npmFormat) {
        super(hostedType, npmFormat);
    }

    @Override
    protected void execute(Repository repository) {
        TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> super.execute(repository));
    }

    @Override
    protected void rebuildMetadata(Repository repository) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(repository);
        Query query = Query.builder().where(ATTRIBUTES_NPM_ASSET_KIND).eq((Object)NpmAttributes.AssetKind.PACKAGE_ROOT.name()).build();
        Iterable assets = tx.browseAssets(query, bucket);
        assets.forEach(asset -> this.rebuildMetadataAsset(repository, (Asset)asset));
    }

    @Override
    protected void rebuildMetadata(Repository repository, String packageName) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(repository);
        Asset packageRootAsset = tx.findAssetWithProperty("name", (Object)packageName, bucket);
        this.rebuildMetadataAsset(repository, packageRootAsset);
    }

    private void rebuildMetadataAsset(Repository repository, Asset packageRootAsset) {
        if (!this.isCanceled() && packageRootAsset != null) {
            try {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
                boolean isChanged = this.removeVersionsWithBuildMetadata(packageRoot);
                if (isChanged) {
                    NpmFacetUtils.savePackageRoot(tx, packageRootAsset, packageRoot);
                }
            }
            catch (IOException e) {
                this.log.error("Error occurred while rebuilding npm metadata {} in repository {}", new Object[]{packageRootAsset.name(), repository.getName(), e});
            }
        }
    }
}

