/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.tasks.datastore;

import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.tasks.BaseRebuildNpmMetadataTask;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

@Named
public class RebuildNpmMetadataTask
extends BaseRebuildNpmMetadataTask {
    private static final int ASSET_BROWSE_LIMIT = 1000;

    @Inject
    public RebuildNpmMetadataTask(@Named(value="hosted") Type hostedType, @Named(value="npm") Format npmFormat) {
        super(hostedType, npmFormat);
    }

    @Override
    protected void rebuildMetadata(Repository repository) {
        NpmContentFacet npmContentFacet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        Continuation assets = npmContentFacet.assets().byKind(NpmAttributes.AssetKind.PACKAGE_ROOT.name()).browse(1000, null);
        while (!this.isCanceled() && !assets.isEmpty()) {
            assets.stream().map(Asset::path).map(path -> StringUtils.removeStart((String)path, (String)"/")).forEach(packageName -> this.rebuildMetadata(repository, (String)packageName));
            assets = npmContentFacet.assets().byKind(NpmAttributes.AssetKind.PACKAGE_ROOT.name()).browse(1000, assets.nextContinuationToken());
        }
    }

    @Override
    protected void rebuildMetadata(Repository repository, String packageName) {
        if (!this.isCanceled()) {
            try {
                boolean isChanged;
                NpmContentFacet npmContentFacet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
                NpmPackageId packageId = NpmPackageId.parse(packageName);
                NestedAttributesMap packageRoot = NpmFacetSupport.loadPackageRoot(packageId, npmContentFacet).orElse(null);
                if (packageRoot != null && (isChanged = this.removeVersionsWithBuildMetadata(packageRoot))) {
                    this.savePackageRoot(npmContentFacet, packageId, packageRoot);
                }
            }
            catch (IOException e) {
                this.log.error("Error occurred while rebuilding npm metadata {} in repository {}", new Object[]{packageName, repository.getName(), e});
            }
        }
    }

    private void savePackageRoot(NpmContentFacet npmContentFacet, NpmPackageId packageId, NestedAttributesMap packageRoot) throws IOException {
        byte[] bytes = NpmJsonUtils.bytes(packageRoot);
        npmContentFacet.put(packageId, (Payload)new StreamPayload(() -> new ByteArrayInputStream(bytes), (long)bytes.length, "application/json"));
    }
}

