/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.tasks;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmFormatAttributesExtractor;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchFacet;
import com.sonatype.nexus.repository.npm.internal.tasks.ReindexNpmRepositoryTask;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.search.index.SearchIndexFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class DatastoreReindexNpmRepositoryTask
extends RepositoryTaskSupport
implements Cancelable,
ReindexNpmRepositoryTask {
    private static final int ASSET_BROWSE_LIMIT = 1000;
    private final NpmPackageParser npmPackageParser;

    @Inject
    public DatastoreReindexNpmRepositoryTask(NpmPackageParser npmPackageParser) {
        this.npmPackageParser = (NpmPackageParser)((Object)Preconditions.checkNotNull((Object)((Object)npmPackageParser)));
    }

    protected void execute(Repository repository) {
        SearchIndexFacet searchIndexFacet = (SearchIndexFacet)repository.facet(SearchIndexFacet.class);
        searchIndexFacet.rebuildIndex();
        NpmContentFacet npmContentFacet = (NpmContentFacet)repository.facet(NpmContentFacet.class);
        Continuation assets = npmContentFacet.assets().byKind(NpmAttributes.AssetKind.TARBALL.name()).browse(1000, null);
        while (!assets.isEmpty() && !this.isCanceled()) {
            try {
                this.updateAssets(repository, (Continuation<FluentAsset>)assets);
                assets = npmContentFacet.assets().byKind(NpmAttributes.AssetKind.TARBALL.name()).browse(1000, assets.nextContinuationToken());
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, RuntimeException.class);
                throw new RuntimeException(e);
            }
        }
        npmContentFacet.withoutAttribute("npm_v1_search_unsupported");
    }

    private void updateAssets(Repository repository, Continuation<FluentAsset> assets) {
        assets.forEach(asset -> this.maybeUpdateAsset(repository, (FluentAsset)asset));
    }

    private void maybeUpdateAsset(Repository repository, FluentAsset asset) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Content content = asset.download();){
                if (content == null) {
                    return;
                }
                Map<String, Object> formatAttributes = this.npmPackageParser.parsePackageJson(() -> ((Content)content).openInputStream());
                if (formatAttributes.isEmpty()) {
                    this.log.warn("No format attributes found in package.json for npm asset {} in repository {}, will not be searchable", (Object)asset.path(), (Object)repository.getName());
                    return;
                }
                NpmFormatAttributesExtractor formatAttributesExtractor = new NpmFormatAttributesExtractor(formatAttributes);
                NestedAttributesMap attributes = asset.attributes("npm");
                formatAttributesExtractor.copyFormatAttributes(attributes);
                asset.attributes(AttributeOperation.SET, "npm", (Object)attributes.backing());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error("Error occurred while reindexing npm asset {} in repository {}, will not be searchable", new Object[]{asset.path(), repository.getName(), e});
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository.optionalFacet(NpmSearchFacet.class).isPresent();
    }

    public String getMessage() {
        return "Reindexing npm format attributes of " + this.getRepositoryField();
    }
}

