/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.tasks;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.scheduling.Cancelable;

public abstract class BaseRebuildNpmMetadataTask
extends RepositoryTaskSupport
implements Cancelable {
    private final Type hostedType;
    private final Format npmFormat;

    protected BaseRebuildNpmMetadataTask(Type hostedType, Format npmFormat) {
        this.hostedType = (Type)Preconditions.checkNotNull((Object)hostedType);
        this.npmFormat = (Format)Preconditions.checkNotNull((Object)npmFormat);
    }

    protected void execute(Repository repository) {
        String packageName = this.getConfiguration().getString("packageName");
        if (Strings.isNullOrEmpty((String)packageName)) {
            this.rebuildMetadata(repository);
        } else {
            this.rebuildMetadata(repository, packageName);
        }
    }

    protected abstract void rebuildMetadata(Repository var1);

    protected abstract void rebuildMetadata(Repository var1, String var2);

    protected boolean appliesTo(Repository repository) {
        return this.npmFormat.equals((Object)repository.getFormat()) && this.hostedType.equals((Object)repository.getType());
    }

    public String getMessage() {
        return "Rebuilding npm metadata of " + this.getRepositoryField();
    }

    protected boolean removeVersionsWithBuildMetadata(NestedAttributesMap packageRoot) {
        NestedAttributesMap versions = packageRoot.child("versions");
        NestedAttributesMap time = packageRoot.child("time");
        boolean isChanged = false;
        for (String version : Sets.newHashSet((Iterable)versions.keys())) {
            if (version.indexOf(43) <= -1) continue;
            versions.remove(version);
            time.remove(version);
            isChanged = true;
        }
        return isChanged;
    }
}

