/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.search.v1;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchFacet;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchParameterExtractor;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponse;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseFactory;
import com.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseMapper;
import java.io.IOException;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.search.query.ElasticSearchQueryService;
import org.sonatype.nexus.repository.search.query.RepositoryQueryBuilder;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
public class NpmSearchFacetHosted
extends FacetSupport
implements NpmSearchFacet {
    private final ElasticSearchQueryService elasticSearchQueryService;
    private final NpmSearchParameterExtractor npmSearchParameterExtractor;
    private final NpmSearchResponseFactory npmSearchResponseFactory;
    private final NpmSearchResponseMapper npmSearchResponseMapper;
    private final int v1SearchMaxResults;

    @Inject
    public NpmSearchFacetHosted(ElasticSearchQueryService elasticSearchQueryService, NpmSearchParameterExtractor npmSearchParameterExtractor, NpmSearchResponseFactory npmSearchResponseFactory, NpmSearchResponseMapper npmSearchResponseMapper, @Named(value="${nexus.npm.v1SearchMaxResults:-250}") int v1SearchMaxResults) {
        this.elasticSearchQueryService = (ElasticSearchQueryService)Preconditions.checkNotNull((Object)elasticSearchQueryService);
        this.npmSearchParameterExtractor = (NpmSearchParameterExtractor)((Object)Preconditions.checkNotNull((Object)((Object)npmSearchParameterExtractor)));
        this.npmSearchResponseFactory = (NpmSearchResponseFactory)((Object)Preconditions.checkNotNull((Object)((Object)npmSearchResponseFactory)));
        this.npmSearchResponseMapper = (NpmSearchResponseMapper)((Object)Preconditions.checkNotNull((Object)((Object)npmSearchResponseMapper)));
        this.v1SearchMaxResults = v1SearchMaxResults;
    }

    @Override
    public Content searchV1(Parameters parameters) throws IOException {
        NpmSearchResponse response;
        String text = this.npmSearchParameterExtractor.extractText(parameters);
        int size = this.npmSearchParameterExtractor.extractSize(parameters);
        int from = this.npmSearchParameterExtractor.extractFrom(parameters);
        if (text.isEmpty()) {
            response = this.npmSearchResponseFactory.buildEmptyResponse();
        } else {
            QueryStringQueryBuilder query = QueryBuilders.queryStringQuery((String)text).allowLeadingWildcard(true).analyzeWildcard(true);
            TermsBuilder terms = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"name").field("assets.attributes.npm.name")).size(this.v1SearchMaxResults).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"versions").addSort((SortBuilder)SortBuilders.fieldSort((String)"assets.attributes.npm.search_normalized_version").order(SortOrder.DESC)).setTrackScores(true).setSize(1));
            SearchResponse searchResponse = this.elasticSearchQueryService.search((QueryBuilder)RepositoryQueryBuilder.repositoryQuery((QueryBuilder)query).inRepositories(new Repository[]{this.getRepository()}), Collections.singletonList(terms));
            Aggregations aggregations = searchResponse.getAggregations();
            Terms nameTerms = (Terms)aggregations.get("name");
            response = this.npmSearchResponseFactory.buildResponseForResults(nameTerms.getBuckets(), size, from);
        }
        String content = this.npmSearchResponseMapper.writeString(response);
        return new Content((Payload)new StringPayload(content, "application/json"));
    }
}

