/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.OrientReplicationFacetSupport;
import org.sonatype.nexus.repository.storage.OrientReplicationIngestionService;

@Named
public class OrientNpmReplicationFacet
extends OrientReplicationFacetSupport {
    private final OrientReplicationIngestionService ingestionService;

    @Inject
    public OrientNpmReplicationFacet(OrientReplicationIngestionService ingestionService) {
        this.ingestionService = Objects.requireNonNull(ingestionService);
    }

    public void doReplicate(String path, AssetBlob assetBlob, NestedAttributesMap assetAttributes, NestedAttributesMap componentAttributes) {
        Repository repository = this.getRepository();
        String fullName = NpmCoordinateUtil.extractFullName(path);
        NpmPackageId packageId = new NpmPackageId(NpmCoordinateUtil.extractScope(fullName), NpmCoordinateUtil.extractName(fullName));
        if (this.isTarball(path)) {
            String componentVersion = NpmCoordinateUtil.extractVersion(path);
            Component component = this.ingestionService.replicateComponent(repository, packageId.name(), componentVersion, packageId.scope(), componentAttributes);
            this.ingestionService.replicateAsset(repository, path, assetAttributes, assetBlob, component);
        } else {
            this.ingestionService.replicateAsset(repository, path, assetAttributes, assetBlob);
        }
    }

    public boolean doReplicateDelete(String path) {
        return this.ingestionService.replicateDeleteAsset(this.getRepository(), path);
    }

    private boolean isTarball(String path) {
        return path.endsWith(".tgz");
    }
}

