/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.sonatype.nexus.repository.npm.internal.NpmQuarantinedVersionFacet;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.storage.StorageFacet;

@FeatureFlag(name="nexus.orient.enabled")
@Named
@Priority(value=0x7FFFFFFF)
public class OrientNpmQuarantinedVersionFacet
extends NpmQuarantinedVersionFacet {
    @Inject
    public OrientNpmQuarantinedVersionFacet(EventManager eventManager, CapabilityRegistry capabilityRegistry, CacheHelper cacheHelper, @Named(value="${nexus.npm.firewall.quarantined_versions_timeout_seconds:-10}") int quarantinedVersionsTimeoutInSeconds, @Named(value="${nexus.npm.firewall.quarantined_versions_cache_duration_hours:-72}") long cacheDurationInHours) {
        super(eventManager, capabilityRegistry, cacheHelper, quarantinedVersionsTimeoutInSeconds, cacheDurationInHours);
    }

    @Override
    public Optional<Blob> getBlob(BlobRef blobRef) {
        return Optional.ofNullable(((StorageFacet)this.getRepository().facet(StorageFacet.class)).blobStore().get(blobRef.getBlobId()));
    }
}

