/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import com.sonatype.nexus.repository.npm.internal.NonResolvableTarballNameException;
import com.sonatype.nexus.repository.npm.internal.NpmAuditFacet;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import com.sonatype.nexus.repository.npm.internal.NpmProxyFacet;
import com.sonatype.nexus.repository.npm.internal.NpmQuarantinedVersionFacet;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import com.sonatype.nexus.repository.npm.internal.orient.OrientNonCatalogedVersionHelperFacet;
import com.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFilter;
import com.sonatype.nexus.repository.npm.orient.NpmFacet;
import com.sonatype.nexus.repository.npm.orient.internal.search.legacy.NpmSearchIndexInvalidatedEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.MissingAssetBlobException;
import org.sonatype.nexus.repository.storage.MissingBlobException;
import org.sonatype.nexus.repository.storage.RetryDeniedException;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.ViewUtils;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientNpmProxyFacet
extends ProxyFacetSupport
implements NpmProxyFacet {
    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        try {
            return super.fetch(context, stale);
        }
        catch (NonResolvableTarballNameException e) {
            this.log.debug("npm tarball URL not resolvable: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected HttpResponse execute(Context context, HttpClient client, HttpRequestBase request) throws IOException {
        String bearerToken = ((HttpClientFacet)this.getRepository().facet(HttpClientFacet.class)).getBearerToken();
        if (StringUtils.isNotBlank((CharSequence)bearerToken)) {
            request.setHeader("Authorization", "Bearer " + bearerToken);
        }
        return super.execute(context, client, request);
    }

    protected Content getCachedContent(Context context) throws IOException {
        NpmProxyFacet.ProxyTarget proxyTarget = (NpmProxyFacet.ProxyTarget)((Object)context.getAttributes().require(NpmProxyFacet.ProxyTarget.class));
        if (proxyTarget.equals((Object)NpmProxyFacet.ProxyTarget.SEARCH_V1_RESULTS)) {
            return null;
        }
        if (NpmProxyFacet.ProxyTarget.PACKAGE == proxyTarget) {
            return this.getPackageRoot(context, NpmPaths.packageId(this.matcherState(context)));
        }
        if (NpmProxyFacet.ProxyTarget.DIST_TAGS == proxyTarget) {
            return this.getDistTags(NpmPaths.packageId(this.matcherState(context)));
        }
        if (NpmProxyFacet.ProxyTarget.TARBALL == proxyTarget) {
            TokenMatcher.State state = this.matcherState(context);
            return this.getTarball(NpmPaths.packageId(state), NpmPaths.tarballName(state));
        }
        if (NpmProxyFacet.ProxyTarget.SEARCH_INDEX == proxyTarget) {
            Content fullIndex = this.getRepositoryRoot();
            if (fullIndex == null) {
                return null;
            }
            return NpmSearchIndexFilter.filterModifiedSince(fullIndex, NpmPaths.indexSince(context.getRequest().getParameters()));
        }
        throw new IllegalStateException();
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        NpmProxyFacet.ProxyTarget proxyTarget = (NpmProxyFacet.ProxyTarget)((Object)context.getAttributes().require(NpmProxyFacet.ProxyTarget.class));
        return this.cacheControllerHolder.require(proxyTarget.getCacheType());
    }

    protected Content store(Context context, Content content) throws IOException {
        NpmProxyFacet.ProxyTarget proxyTarget = (NpmProxyFacet.ProxyTarget)((Object)context.getAttributes().require(NpmProxyFacet.ProxyTarget.class));
        if (proxyTarget.equals((Object)NpmProxyFacet.ProxyTarget.SEARCH_V1_RESULTS)) {
            return content;
        }
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, NpmFacetUtils.HASH_ALGORITHMS);){
            if (NpmProxyFacet.ProxyTarget.PACKAGE == proxyTarget) {
                return this.putPackageRoot(NpmPaths.packageId(this.matcherState(context)), tempBlob, content);
            }
            if (NpmProxyFacet.ProxyTarget.DIST_TAGS == proxyTarget) {
                this.putPackageRoot(NpmPaths.packageId(this.matcherState(context)), tempBlob, content);
                return this.getDistTags(NpmPaths.packageId(this.matcherState(context)));
            }
            if (NpmProxyFacet.ProxyTarget.TARBALL == proxyTarget) {
                TokenMatcher.State state = this.matcherState(context);
                return this.putTarball(NpmPaths.packageId(state), NpmPaths.tarballName(state), tempBlob, content, context);
            }
            if (NpmProxyFacet.ProxyTarget.SEARCH_INDEX == proxyTarget) {
                Content fullIndex = this.putRepositoryRoot(tempBlob, content);
                return NpmSearchIndexFilter.filterModifiedSince(fullIndex, NpmPaths.indexSince(context.getRequest().getParameters()));
            }
            throw new IllegalStateException();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    protected String getUrl(@Nonnull Context context) {
        Parameters parameters;
        String url = context.getRequest().getPath().substring(1);
        NpmProxyFacet.ProxyTarget proxyTarget = (NpmProxyFacet.ProxyTarget)((Object)context.getAttributes().require(NpmProxyFacet.ProxyTarget.class));
        if (NpmProxyFacet.ProxyTarget.TARBALL == proxyTarget) {
            TokenMatcher.State state = this.matcherState(context);
            try {
                NestedAttributesMap packageVersion = this.retrievePackageVersion(NpmPaths.packageId(state), NpmPaths.tarballName(state), context);
                url = (String)packageVersion.child("dist").get("tarball", String.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else if (NpmProxyFacet.ProxyTarget.PACKAGE == proxyTarget) {
            NpmPackageId packageId = NpmPaths.packageId(this.matcherState(context));
            if (packageId.scope() != null) {
                String newUrl = "@" + packageId.scope() + "%2f" + packageId.name();
                this.log.trace("Scoped package URL fix: {} -> {}", (Object)url, (Object)newUrl);
                url = newUrl;
            }
        } else if (NpmProxyFacet.ProxyTarget.DIST_TAGS == proxyTarget) {
            NpmPackageId packageId = NpmPaths.packageId(this.matcherState(context));
            if (packageId.scope() != null) {
                String newUrl = "@" + packageId.scope() + "%2f" + packageId.name();
                this.log.trace("Scoped package URL fix: {} -> {}", (Object)url, (Object)newUrl);
                url = newUrl;
            } else {
                url = packageId.name();
            }
        } else if (NpmProxyFacet.ProxyTarget.SEARCH_V1_RESULTS == proxyTarget && (parameters = context.getRequest().getParameters()) != null) {
            return ViewUtils.buildUrlWithParameters((String)url, (Parameters)parameters);
        }
        return url;
    }

    @TransactionalTouchMetadata
    protected void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent npm asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @Nullable
    @TransactionalTouchBlob
    public Content getPackageRoot(Context context, NpmPackageId packageId) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            return null;
        }
        return NpmFacetUtils.toContent(this.getRepository(), packageRootAsset).fieldMatchers(this.getFieldMatchers(packageId, packageRootAsset, context.getRepository())).packageId(packageRootAsset.name()).missingBlobInputStreamSupplier((StreamPayload.InputStreamFunction<MissingAssetBlobException>)((StreamPayload.InputStreamFunction)missingBlobException -> this.doGetOnMissingBlob(context, (MissingAssetBlobException)((Object)missingBlobException))));
    }

    private List<NpmFieldMatcher> getFieldMatchers(NpmPackageId packageId, Asset packageRootAsset, Repository repository) {
        ArrayList<NpmFieldMatcher> fieldMatchers = new ArrayList<NpmFieldMatcher>();
        ((OrientNonCatalogedVersionHelperFacet)this.facet(OrientNonCatalogedVersionHelperFacet.class)).maybeAddExcludedVersionsFieldMatchers(fieldMatchers, packageRootAsset, repository);
        ((NpmQuarantinedVersionFacet)this.facet(NpmQuarantinedVersionFacet.class)).maybeAddExcludedVersionsFieldMatchers(fieldMatchers, packageId, packageRootAsset.blobRef(), repository);
        fieldMatchers.add(NpmFieldFactory.rewriteTarballUrlMatcher(this.getRepository(), packageId.id()));
        return fieldMatchers;
    }

    @TransactionalTouchMetadata
    protected Content getDistTags(NpmPackageId packageId) {
        Preconditions.checkNotNull((Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset != null) {
            try {
                NestedAttributesMap attributesMap = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
                NestedAttributesMap distTags = attributesMap.child("dist-tags");
                return NpmFacetUtils.distTagsToContent(distTags);
            }
            catch (IOException e) {
                this.log.error("Unable to read packageRoot {}", (Object)packageId.id(), (Object)e);
            }
        }
        return null;
    }

    private Content putPackageRoot(NpmPackageId packageId, TempBlob tempBlob, Content payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)tempBlob);
        NestedAttributesMap packageRoot = NpmFacetUtils.parse((InputStreamSupplier)tempBlob);
        try {
            return this.doPutPackageRoot(packageId, packageRoot, payload, true);
        }
        catch (MissingBlobException | RetryDeniedException e) {
            return this.maybeHandleMissingBlob((RuntimeException)e, packageId, packageRoot, payload);
        }
    }

    @TransactionalStoreBlob
    protected Content doPutPackageRoot(NpmPackageId packageId, NestedAttributesMap packageRoot, Content content, boolean mergePackageRoot) throws IOException {
        this.log.debug("Storing package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        NestedAttributesMap newPackageRoot = packageRoot;
        Asset asset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(packageId.id());
        } else if (mergePackageRoot) {
            newPackageRoot = this.mergeNewRootWithExistingRoot(tx, newPackageRoot, asset);
        }
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes()));
        NpmFacetUtils.savePackageRoot(tx, asset, newPackageRoot);
        return NpmFacetUtils.toContent(this.getRepository(), asset).fieldMatchers(this.getFieldMatchers(packageId, asset, this.getRepository())).revId(asset.name()).packageId(packageId.id());
    }

    private NestedAttributesMap mergeNewRootWithExistingRoot(StorageTx tx, NestedAttributesMap newPackageRoot, Asset asset) throws IOException {
        NestedAttributesMap existingPackageRoot = NpmFacetUtils.loadPackageRoot(tx, asset);
        return NpmMetadataUtils.mergePackageRoots(newPackageRoot, existingPackageRoot, NpmMetadataUtils.findCachedVersionsRemovedFromRemote(existingPackageRoot, newPackageRoot, this.componentExists(tx)));
    }

    private BiFunction<NpmPackageId, String, Boolean> componentExists(StorageTx tx) {
        return (packageId, version) -> tx.componentExists(packageId.scope(), packageId.name(), version, this.getRepository());
    }

    @Nullable
    @TransactionalTouchBlob
    protected Content getTarball(NpmPackageId packageId, String tarballName) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.getTarballContent(tx, tx.findBucket(this.getRepository()), packageId, tarballName).orElse(null);
    }

    private Content putTarball(NpmPackageId packageId, String tarballName, TempBlob tempBlob, Content content, Context context) throws IOException {
        String version;
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        Preconditions.checkNotNull((Object)tempBlob);
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)context);
        try {
            version = this.retrievePackageVersion(packageId, tarballName, context).getKey();
        }
        catch (Exception e) {
            this.log.debug("Unable to get package version from metadata for {}, falling back to the tarball name", (Object)packageId, (Object)e);
            version = NpmCoordinateUtil.extractVersion(tarballName);
        }
        return this.doPutTarball(packageId, tarballName, tempBlob, content, version);
    }

    @TransactionalStoreBlob
    protected Content doPutTarball(NpmPackageId packageId, String tarballName, TempBlob tempBlob, Content content, String version) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = NpmFacetUtils.createTarballAssetBlob(tx, packageId, tarballName, tempBlob);
        NpmFacet npmFacet = (NpmFacet)this.facet(NpmFacet.class);
        npmFacet.putTarball(packageId.id(), tarballName, assetBlob, content.getAttributes(), version);
        return NpmFacetUtils.getTarballContent(tx, tx.findBucket(this.getRepository()), packageId, tarballName).orElse(null);
    }

    private Content putRepositoryRoot(TempBlob tempBlob, Content content) throws IOException {
        Preconditions.checkNotNull((Object)tempBlob);
        Preconditions.checkNotNull((Object)content);
        Content result = this.doPutRepositoryRoot(tempBlob, content);
        this.getEventManager().post((Object)new NpmSearchIndexInvalidatedEvent(this.getRepository()));
        return result;
    }

    @Nullable
    @TransactionalTouchBlob
    protected Content getRepositoryRoot() throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return null;
        }
        return NpmFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @TransactionalStoreBlob
    protected Content doPutRepositoryRoot(TempBlob tempBlob, Content content) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name("-/all");
        }
        return NpmFacetUtils.saveRepositoryRoot(tx, asset, tempBlob, content);
    }

    protected NestedAttributesMap retrievePackageVersion(NpmPackageId packageId, String tarballName, Context context) throws IOException {
        NpmMetadataUtils.retrievePackageRoot(packageId, context, this.getRepository());
        return this.retrievePackageVersionTx(packageId, tarballName);
    }

    @TransactionalTouchBlob
    protected NestedAttributesMap retrievePackageVersionTx(NpmPackageId packageId, String tarballName) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.findPackageRootAsset(packageId);
        if (asset == null) {
            throw new NonResolvableTarballNameException("Could not find package " + packageId);
        }
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, asset);
        NestedAttributesMap packageVersion = NpmMetadataUtils.selectVersionByTarballName(packageRoot, tarballName);
        if (packageVersion == null) {
            throw new NonResolvableTarballNameException("Could not find package " + packageId + " version for " + tarballName);
        }
        return packageVersion;
    }

    @Nullable
    @Transactional
    protected Asset findPackageRootAsset(NpmPackageId packageId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
    }

    private TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    private Content maybeHandleMissingBlob(RuntimeException e, NpmPackageId packageId, NestedAttributesMap packageRoot, Content payload) throws IOException {
        BlobRef blobRef = null;
        if (e instanceof MissingBlobException) {
            blobRef = ((MissingBlobException)((Object)e)).getBlobRef();
        } else if (e.getCause() instanceof MissingBlobException) {
            blobRef = ((MissingBlobException)e.getCause()).getBlobRef();
        }
        if (Objects.nonNull(blobRef)) {
            this.log.warn("Unable to find blob {} for {}, skipping merge of package root", (Object)blobRef, (Object)packageId);
            return this.doPutPackageRoot(packageId, packageRoot, payload, false);
        }
        throw e;
    }

    private InputStream doGetOnMissingBlob(Context context, MissingAssetBlobException e) {
        this.log.warn("Unable to find blob {} for {}, will check remote", (Object)e.getBlobRef(), (Object)this.getUrl(context));
        return (InputStream)Transactional.operation.withDb(((StorageFacet)this.facet(StorageFacet.class)).txSupplier()).call(() -> {
            try {
                return this.get(context, null).openInputStream();
            }
            catch (IOException e1) {
                this.log.error("Unable to check remote for missing blob {} at {}", new Object[]{e.getBlobRef(), this.getUrl(context), e1});
                return NpmFacetUtils.errorInputStream(String.format("Missing blob for %s. Unable to check remote %s for retrieving latest copy.", e.getAsset().name(), this.getUrl(context)));
            }
        });
    }

    @Override
    public void invalidateProxyCaches() {
        super.invalidateProxyCaches();
        NpmAuditFacet npmAuditFacet = (NpmAuditFacet)this.getRepository().facet(NpmAuditFacet.class);
        npmAuditFacet.clearCache();
        ((OrientNonCatalogedVersionHelperFacet)this.facet(OrientNonCatalogedVersionHelperFacet.class)).clearCache();
        ((NpmQuarantinedVersionFacet)this.facet(NpmQuarantinedVersionFacet.class)).clearCache();
    }
}

