/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageRootMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPublishRequest;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import com.sonatype.nexus.repository.npm.internal.orient.NpmRequestParser;
import com.sonatype.nexus.repository.npm.internal.orient.NpmRevisionUpgradeRequestEvent;
import com.sonatype.nexus.repository.npm.internal.orient.NpmWritePolicySelector;
import com.sonatype.nexus.repository.npm.internal.orient.OrientNpmHostedFacet;
import com.sonatype.nexus.repository.npm.orient.NpmFacet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientNpmHostedFacetImpl
extends FacetSupport
implements OrientNpmHostedFacet {
    private final NpmRequestParser npmRequestParser;

    @Inject
    public OrientNpmHostedFacetImpl(NpmRequestParser npmRequestParser) {
        this.npmRequestParser = (NpmRequestParser)((Object)Preconditions.checkNotNull((Object)((Object)npmRequestParser)));
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)new NpmWritePolicySelector());
    }

    @Override
    @TransactionalTouchBlob
    public Optional<Content> getPackage(NpmPackageId packageId) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        this.log.debug("Getting package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            return Optional.empty();
        }
        return Optional.of(NpmFacetUtils.toContent(this.getRepository(), packageRootAsset).fieldMatchers(Arrays.asList(NpmFieldFactory.missingRevFieldMatcher(() -> this.generateNewRevId(packageRootAsset)), NpmFieldFactory.rewriteTarballUrlMatcher(this.getRepository().getName(), packageId.id()))).packageId(packageRootAsset.name()));
    }

    protected String generateNewRevId(Asset packageRootAsset) {
        String newRevision = EntityHelper.version((Entity)packageRootAsset).getValue();
        this.getEventManager().post((Object)new NpmRevisionUpgradeRequestEvent(packageRootAsset, newRevision));
        return newRevision;
    }

    @Subscribe
    public void on(NpmRevisionUpgradeRequestEvent event) {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            this.upgradeRevisionOnPackageRoot(event.getPackageRootAsset(), event.getRevision());
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalTouchBlob
    protected void upgradeRevisionOnPackageRoot(Asset packageRootAsset, String revision) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        NpmPackageId packageId = NpmPackageId.parse(packageRootAsset.name());
        Asset asset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (asset == null) {
            this.log.error("Failed to update revision on package root. Asset for id '{}' didn't exist", (Object)packageId.id());
            return;
        }
        try {
            NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, asset);
            packageRoot.set("_rev", (Object)revision);
            NpmFacetUtils.savePackageRoot((StorageTx)UnitOfWork.currentTx(), packageRootAsset, packageRoot);
        }
        catch (IOException e) {
            this.log.warn("Failed to update revision in package root. Revision '{}' was not set and might cause delete for that revision to fail for Asset {}", new Object[]{revision, packageRootAsset, e});
        }
    }

    @Override
    public void putPackage(NpmPackageId packageId, @Nullable String revision, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)payload);
        Throwable throwable = null;
        Object var5_6 = null;
        try (NpmPublishRequest request = this.npmRequestParser.parsePublish(this.getRepository(), payload);){
            this.putPublishRequest(packageId, revision, request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Asset putPackage(Map<String, Object> packageJson, TempBlob tempBlob) throws IOException {
        Preconditions.checkNotNull(packageJson);
        Preconditions.checkNotNull((Object)tempBlob);
        this.log.debug("Storing package: {}", packageJson);
        Preconditions.checkNotNull((Object)packageJson.get("name"), (Object)"Uploaded package is invalid, or is missing package.json");
        NestedAttributesMap metadata = NpmPackageRootMetadataUtils.createFullPackageMetadata(new NestedAttributesMap("metadata", packageJson), this.getRepository().getName(), ((HashCode)tempBlob.getHashes().get(HashAlgorithm.SHA1)).toString(), "", NpmVersionComparator.extractAlwaysPackageVersion);
        NpmPackageId packageId = NpmPackageId.parse((String)metadata.get("name"));
        return this.putPackage(packageId, metadata, tempBlob);
    }

    @Override
    public Asset putPackage(Map<String, Object> packageJson, AssetBlob assetBlob) throws IOException {
        Preconditions.checkNotNull(packageJson);
        Preconditions.checkNotNull((Object)assetBlob);
        this.log.debug("Storing package: {}", packageJson);
        Preconditions.checkNotNull((Object)packageJson.get("name"), (Object)"Uploaded package is invalid, or is missing package.json");
        NestedAttributesMap metadata = NpmPackageRootMetadataUtils.createFullPackageMetadata(new NestedAttributesMap("metadata", packageJson), this.getRepository().getName(), ((HashCode)assetBlob.getHashes().get(HashAlgorithm.SHA1)).toString(), "", NpmVersionComparator.extractAlwaysPackageVersion);
        NpmPackageId packageId = NpmPackageId.parse((String)metadata.get("name"));
        return this.putPackage(packageId, metadata, assetBlob);
    }

    @Override
    public void attachDistTags(NpmPackageId packageId, Map<String, Object> distTagsDominant) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        Map distTags = (Map)Objects.requireNonNull(packageRoot.get("dist-tags"));
        for (Map.Entry<String, Object> distTag : distTagsDominant.entrySet()) {
            String tagName = distTag.getKey();
            String tagValue = String.valueOf(distTag.getValue());
            Component packageTarballComponent = NpmFacetUtils.findPackageTarballComponent(tx, this.getRepository(), packageId, tagValue);
            if (packageTarballComponent == null) {
                this.log.debug("Unable to attach {} {}. No tag {} in the repository {}", new Object[]{packageId, tagName, tagValue, this.getRepository().getName()});
                continue;
            }
            distTags.put(tagName, tagValue);
        }
        NpmFacetUtils.savePackageRoot(tx, packageRootAsset, packageRoot);
    }

    @Override
    @TransactionalStoreBlob
    public AssetBlob getHardLinkingTarballBlob(File content) throws IOException {
        Preconditions.checkNotNull((Object)content);
        String path = content.getPath();
        Path contentPath = content.toPath();
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Map<HashAlgorithm, HashCode> hashes = Collections.singletonMap(HashAlgorithm.SHA1, Hashing.sha1().hashBytes(Files.readAllBytes(contentPath)));
        long size = Files.size(contentPath);
        return tx.createBlob(path, contentPath, hashes, null, NpmAttributes.AssetKind.TARBALL.getContentType(), size);
    }

    @TransactionalStoreBlob
    protected Asset putPackage(NpmPackageId packageId, NestedAttributesMap requestPackageRoot, TempBlob tarballTempBlob) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)requestPackageRoot);
        Preconditions.checkNotNull((Object)tarballTempBlob);
        this.log.debug("Storing package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String tarballName = NpmMetadataUtils.extractTarballName(requestPackageRoot);
        AssetBlob assetBlob = NpmFacetUtils.createTarballAssetBlob(tx, packageId, tarballName, tarballTempBlob);
        this.putPackageRoot(packageId, null, requestPackageRoot);
        return ((NpmFacet)this.facet(NpmFacet.class)).putTarball(packageId.id(), tarballName, assetBlob, new AttributesMap());
    }

    @TransactionalStoreBlob
    protected Asset putPackage(NpmPackageId packageId, NestedAttributesMap requestPackageRoot, AssetBlob tarballAssetBlob) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)requestPackageRoot);
        Preconditions.checkNotNull((Object)tarballAssetBlob);
        this.log.debug("Storing package: {}", (Object)packageId);
        String tarballName = NpmMetadataUtils.extractTarballName(requestPackageRoot);
        this.putPackageRoot(packageId, null, requestPackageRoot);
        return ((NpmFacet)this.facet(NpmFacet.class)).putTarball(packageId.id(), tarballName, tarballAssetBlob, new AttributesMap());
    }

    @TransactionalStoreBlob
    protected void putPublishRequest(NpmPackageId packageId, @Nullable String revision, NpmPublishRequest request) throws IOException {
        this.log.debug("Storing package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        NestedAttributesMap packageRoot = request.getPackageRoot();
        NestedAttributesMap attachments = packageRoot.child("_attachments");
        if (!attachments.isEmpty()) {
            for (String name : attachments.keys()) {
                NestedAttributesMap attachment = attachments.child(name);
                NestedAttributesMap packageVersion = NpmMetadataUtils.selectVersionByTarballName(packageRoot, name);
                this.putTarball(tx, packageId, packageVersion, attachment, request);
            }
        }
        this.putPackageRoot(packageId, revision, packageRoot);
    }

    @Override
    @TransactionalStoreBlob
    public void putPackageRoot(NpmPackageId packageId, @Nullable String revision, NestedAttributesMap newPackageRoot) throws IOException {
        this.log.debug("Storing package root: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        boolean update = false;
        NestedAttributesMap packageRoot = newPackageRoot;
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (packageRootAsset != null) {
            NestedAttributesMap oldPackageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
            String rev = revision;
            if (rev == null) {
                rev = (String)packageRoot.get("_rev", String.class);
            }
            if (rev != null) {
                Preconditions.checkArgument((boolean)rev.equals(oldPackageRoot.get("_rev", String.class)));
                update = true;
            } else {
                packageRoot = NpmMetadataUtils.overlay(oldPackageRoot, packageRoot);
            }
        }
        boolean createdPackageRoot = false;
        if (packageRootAsset == null) {
            packageRootAsset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(packageId.id());
            createdPackageRoot = true;
        }
        this.updateRevision(packageRoot, packageRootAsset, createdPackageRoot);
        NpmFacetUtils.savePackageRoot(tx, packageRootAsset, packageRoot);
        if (update) {
            this.updateDeprecationFlags(tx, packageId, packageRoot);
        }
    }

    private void updateRevision(NestedAttributesMap packageRoot, Asset packageRootAsset, boolean createdPackageRoot) {
        String newRevision = "1";
        if (!createdPackageRoot) {
            if (packageRoot.contains("_rev")) {
                String rev = (String)packageRoot.get("_rev", String.class);
                newRevision = Integer.toString(Integer.parseInt(rev) + 1);
            } else {
                newRevision = EntityHelper.version((Entity)packageRootAsset).getValue();
            }
        }
        packageRoot.set("_id", (Object)packageRootAsset.name());
        packageRoot.set("_rev", (Object)newRevision);
    }

    private void updateDeprecationFlags(StorageTx tx, NpmPackageId packageId, NestedAttributesMap packageRoot) {
        NestedAttributesMap versions = packageRoot.child("versions");
        for (Component tarballComponent : NpmFacetUtils.findPackageTarballComponents(tx, this.getRepository(), packageId)) {
            boolean deprecated;
            Preconditions.checkState((boolean)versions.contains(tarballComponent.version()), (String)"Package %s lacks tarball version %s", (Object)packageId, (Object)tarballComponent.version());
            NestedAttributesMap version = versions.child(tarballComponent.version());
            String deprecationMessage = (String)version.get("deprecated", String.class);
            boolean bl = deprecated = !Strings2.isBlank((String)deprecationMessage);
            if (deprecated && !deprecationMessage.equals(tarballComponent.formatAttributes().get("deprecated", String.class))) {
                tarballComponent.formatAttributes().set("deprecated", (Object)deprecationMessage);
                tx.saveComponent(tarballComponent);
                continue;
            }
            if (deprecated || !tarballComponent.formatAttributes().contains("deprecated")) continue;
            tarballComponent.formatAttributes().remove("deprecated");
            tx.saveComponent(tarballComponent);
        }
    }

    private void putTarball(StorageTx tx, NpmPackageId packageId, NestedAttributesMap packageVersion, NestedAttributesMap attachment, NpmPublishRequest request) throws IOException {
        String tarballName = NpmMetadataUtils.extractTarballName(attachment.getKey());
        this.log.debug("Storing tarball: {}@{} ({})", new Object[]{packageId, packageVersion.get("version", String.class), tarballName});
        TempBlob tempBlob = request.requireBlob((String)attachment.require("data", String.class));
        AssetBlob assetBlob = NpmFacetUtils.createTarballAssetBlob(tx, packageId, tarballName, tempBlob);
        NpmFacet npmFacet = (NpmFacet)this.facet(NpmFacet.class);
        npmFacet.putTarball(packageId.id(), tarballName, assetBlob, new AttributesMap());
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> deletePackage(NpmPackageId packageId, @Nullable String revision) throws IOException {
        return this.deletePackage(packageId, revision, true);
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> deletePackage(NpmPackageId packageId, @Nullable String revision, boolean deleteBlobs) throws IOException {
        Asset packageRootAsset;
        Preconditions.checkNotNull((Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        if (revision != null && (packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId)) != null) {
            NestedAttributesMap oldPackageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
            Preconditions.checkArgument((boolean)revision.equals(oldPackageRoot.get("_rev", String.class)));
        }
        return NpmFacetUtils.deletePackageRoot(tx, this.getRepository(), packageId, deleteBlobs);
    }

    @Override
    @TransactionalTouchBlob
    public Optional<Content> getTarball(NpmPackageId packageId, String tarballName) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.getTarballContent(tx, tx.findBucket(this.getRepository()), packageId, tarballName);
    }

    @Override
    @TransactionalDeleteBlob
    public Optional<String> deleteTarball(NpmPackageId packageId, String tarballName) {
        return this.deleteTarball(packageId, tarballName, true);
    }

    @Override
    @TransactionalTouchBlob
    public void recalculateLatestBySemanticVersion(NpmPackageId packageId) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Iterable<Component> packageTarballComponents = NpmFacetUtils.findPackageTarballComponents(tx, this.getRepository(), packageId);
        String maxVersion = StreamSupport.stream(packageTarballComponents.spliterator(), false).max((o1, o2) -> VersionComparator.INSTANCE.compare(o1.version(), o2.version())).map(Component::version).orElse(null);
        if (maxVersion == null) {
            return;
        }
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (packageRootAsset == null) {
            return;
        }
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        packageRoot.child("dist-tags").set("latest", (Object)maxVersion);
        NpmFacetUtils.savePackageRoot(tx, packageRootAsset, packageRoot);
    }

    @Override
    @TransactionalDeleteBlob
    public Optional<String> deleteTarball(NpmPackageId packageId, String tarballName, boolean deleteBlob) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.deleteTarball(tx, this.getRepository(), packageId, tarballName, deleteBlob);
    }

    @Override
    @TransactionalTouchBlob
    public Optional<Content> getDistTags(NpmPackageId packageId) {
        Preconditions.checkNotNull((Object)packageId);
        this.log.debug("Getting package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            return Optional.empty();
        }
        try {
            NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
            NestedAttributesMap distTags = packageRoot.child("dist-tags");
            return Optional.of(NpmFacetUtils.distTagsToContent(distTags));
        }
        catch (IOException e) {
            this.log.info("Unable to obtain dist-tags for {}", (Object)packageId.id(), (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public void putDistTags(NpmPackageId packageId, String tag, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tag);
        this.log.debug("Updating distTags: {}", (Object)packageId);
        if ("latest".equals(tag)) {
            throw new IOException("Unable to update latest tag");
        }
        String version = this.parseVersionToTag(packageId, tag, payload);
        this.doPutDistTags(packageId, tag, version);
    }

    @TransactionalStoreMetadata
    protected void doPutDistTags(NpmPackageId packageId, String tag, String version) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            return;
        }
        if (NpmFacetUtils.findPackageTarballComponent(tx, this.getRepository(), packageId, version) == null) {
            throw new IOException(String.format("version %s of package %s is not present in repository %s", version, packageId.id(), this.getRepository().getName()));
        }
        try {
            NpmFacetUtils.updateDistTags(tx, packageRootAsset, tag, version);
        }
        catch (IOException e) {
            this.log.error("Unable to update dist-tags for {}", (Object)packageId.id(), (Object)e);
        }
    }

    @Override
    @TransactionalStoreMetadata
    public void deleteDistTags(NpmPackageId packageId, String tag, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tag);
        this.log.debug("Deleting distTags: {}", (Object)packageId);
        if ("latest".equals(tag)) {
            throw new IOException("Unable to delete latest");
        }
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            return;
        }
        try {
            NpmFacetUtils.deleteDistTags(tx, packageRootAsset, tag);
        }
        catch (IOException e) {
            this.log.info("Unable to obtain dist-tags for {}", (Object)packageId.id(), (Object)e);
        }
    }

    private String parseVersionToTag(NpmPackageId packageId, @Nullable String tag, Payload payload) throws IOException {
        String version;
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream is = payload.openInputStream();){
            version = IOUtils.toString((InputStream)is).replaceAll("\"", "");
            this.log.debug("Adding tag {}:{} to {}", new Object[]{tag, version, packageId});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return version;
    }
}

