/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmGroupUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPaths;
import com.sonatype.nexus.repository.npm.internal.orient.NpmContent;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.AssetUpdatedEvent;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.MissingAssetBlobException;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Facet.Exposed
public class OrientNpmGroupDataFacet
extends FacetSupport {
    private static final Set<String> SKIP_MATCHERS = Sets.newHashSet((Object[])new String[]{"tarball", "_rev"});
    private final boolean mergeMetadata;
    private GroupFacet groupFacet;
    @Nullable
    private CooperationFactory.Builder cooperationBuilder;
    @Nullable
    private Cooperation packageRootCooperation;

    @Inject
    public OrientNpmGroupDataFacet(@Named(value="${nexus.npm.mergeGroupMetadata:-true}") boolean mergeMetadata) {
        this.mergeMetadata = mergeMetadata;
    }

    @Inject
    protected void configureCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.npm.packageRoot.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.npm.packageRoot.cooperation.majorTimeout:-0s}") Time majorTimeout, @Named(value="${nexus.npm.packageRoot.cooperation.minorTimeout:-30s}") Time minorTimeout, @Named(value="${nexus.npm.packageRoot.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        if (cooperationEnabled) {
            this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
        }
    }

    @VisibleForTesting
    void buildCooperation() {
        if (Objects.nonNull(this.cooperationBuilder)) {
            this.packageRootCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":packageRoot");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.groupFacet = (GroupFacet)this.getRepository().facet(GroupFacet.class);
        this.buildCooperation();
    }

    @Nullable
    public Content buildPackageRoot(Map<Repository, Response> responses, Context context) throws IOException {
        if (Objects.isNull(this.packageRootCooperation)) {
            return this.buildMergedPackageRoot(responses, context);
        }
        String cooperationKey = NpmGroupUtils.getCooperationKeyForBuildMergedPackageRoot(context);
        try {
            return (Content)this.packageRootCooperation.cooperate(cooperationKey, failover -> {
                Content latestContent;
                if (failover && Objects.nonNull(latestContent = (Content)this.packageRootCooperation.join(() -> this.getFromCache(responses, context)))) {
                    return latestContent;
                }
                return this.buildMergedPackageRoot(responses, context);
            });
        }
        catch (IOException e) {
            this.log.error("Unable to use Cooperation to merge {} for repository {}", new Object[]{cooperationKey, context.getRepository().getName(), e});
            return null;
        }
    }

    @Nullable
    public NpmContent getFromCache(Map<Repository, Response> responses, Context context) throws IOException {
        Asset packageRootAsset = this.getPackageRootAssetFromCache(context);
        if (Objects.isNull(packageRootAsset)) {
            return null;
        }
        NpmContent npmContent = NpmFacetUtils.toContent(this.getRepository(), packageRootAsset);
        List<NpmFieldMatcher> fieldMatchers = this.getMemberFieldMatchers(responses);
        fieldMatchers.add(NpmFieldFactory.rewriteTarballUrlMatcher(this.getRepository(), packageRootAsset.name()));
        npmContent.fieldMatchers(fieldMatchers);
        npmContent.packageId(packageRootAsset.name());
        npmContent.missingBlobInputStreamSupplier((StreamPayload.InputStreamFunction<MissingAssetBlobException>)((StreamPayload.InputStreamFunction)missingBlobException -> this.buildMergedPackageRootOnMissingBlob(responses, context, (MissingAssetBlobException)((Object)missingBlobException))));
        return !this.groupFacet.isStale((Content)npmContent) ? npmContent : null;
    }

    @Nullable
    @TransactionalTouchBlob
    protected Asset getPackageRootAssetFromCache(Context context) throws IOException {
        Preconditions.checkNotNull((Object)context);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), NpmPaths.packageId(OrientNpmGroupDataFacet.matcherState(context)));
    }

    @Nullable
    @VisibleForTesting
    protected Content buildMergedPackageRoot(Map<Repository, Response> responses, Context context) throws IOException {
        NestedAttributesMap result;
        NpmPackageId packageId;
        Preconditions.checkNotNull(responses);
        Preconditions.checkNotNull((Object)context);
        if (responses.isEmpty()) {
            this.log.debug("Unable to create package root for repository {}. Members had no metadata to merge.", (Object)context.getRepository().getName());
            return null;
        }
        List<Content> contents = responses.values().stream().map(response -> (Content)response.getPayload()).collect(Collectors.toList());
        if (this.shouldServeFirstResult(contents, packageId = NpmPaths.packageId(OrientNpmGroupDataFacet.matcherState(context)))) {
            result = NpmMetadataUtils.parseContent((Content)contents.get(0));
        } else {
            this.log.debug("Merging results from {} repositories", (Object)responses.size());
            Collections.reverse(contents);
            result = NpmMetadataUtils.mergeContents(contents);
        }
        NpmMetadataUtils.rewriteTarballUrl(context.getRepository().getName(), result);
        List<NpmFieldMatcher> proxyFieldMatchers = this.getMemberFieldMatchers(responses);
        return this.saveToCache(packageId, result, proxyFieldMatchers);
    }

    private List<NpmFieldMatcher> getMemberFieldMatchers(Map<Repository, Response> responses) {
        return responses.entrySet().stream().flatMap(e -> {
            NpmContent npmContent = (NpmContent)((Response)e.getValue()).getPayload();
            if (npmContent != null && npmContent.getFieldMatchers() != null) {
                return npmContent.getFieldMatchers().stream();
            }
            return Stream.empty();
        }).filter(npmFieldMatcher -> !SKIP_MATCHERS.contains(npmFieldMatcher.getFieldName())).collect(Collectors.toList());
    }

    protected Content saveToCache(NpmPackageId packageId, NestedAttributesMap result, List<NpmFieldMatcher> proxyFieldMatchers) throws IOException {
        Asset packageRootAsset = this.savePackageRootToCache(packageId, result);
        ArrayList<NpmFieldMatcher> fieldMatchers = new ArrayList<NpmFieldMatcher>();
        fieldMatchers.addAll(NpmFieldFactory.REMOVE_DEFAULT_FIELDS_MATCHERS);
        fieldMatchers.addAll(proxyFieldMatchers);
        return NpmFacetUtils.toContent(this.getRepository(), packageRootAsset).fieldMatchers(fieldMatchers).packageId(packageRootAsset.name());
    }

    @TransactionalStoreBlob
    protected Asset savePackageRootToCache(NpmPackageId packageId, NestedAttributesMap result) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getAsset(tx, packageId);
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, null);
        this.groupFacet.maintainCacheInfo(contentAttributes);
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        NpmFacetUtils.savePackageRoot(tx, asset, result);
        return asset;
    }

    protected InputStream buildMergedPackageRootOnMissingBlob(Map<Repository, Response> responses, Context context, MissingAssetBlobException e) throws IOException {
        Content content;
        if (this.packageRootCooperation == null) {
            content = this.doBuildMergedPackageRootOnMissingBlob(responses, context, e);
        } else {
            String cooperationKey = NpmGroupUtils.getCooperationKeyForBuildMergedPackageRoot(context);
            content = (Content)this.packageRootCooperation.cooperate(cooperationKey, failover -> this.doBuildMergedPackageRootOnMissingBlob(responses, context, e));
        }
        return Objects.nonNull(content) ? content.openInputStream() : NpmFacetUtils.errorInputStream("Unable to retrieve merged package root on recovery for missing blob");
    }

    protected Content doBuildMergedPackageRootOnMissingBlob(Map<Repository, Response> responses, Context context, MissingAssetBlobException e) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.info("Missing blob {} containing cached metadata {}, deleting asset and triggering rebuild.", new Object[]{e.getBlobRef(), e.getAsset(), e});
        } else {
            this.log.info("Missing blob {} containing cached metadata {}, deleting asset and triggering rebuild.", (Object)e.getBlobRef(), (Object)e.getAsset().name());
        }
        this.cleanupPackageRootAssetOnlyFromCache(e.getAsset());
        return this.buildMergedPackageRoot(responses, context);
    }

    @Transactional
    protected void cleanupPackageRootAssetOnlyFromCache(Asset packageRootAsset) {
        Preconditions.checkNotNull((Object)packageRootAsset);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        tx.deleteAsset(packageRootAsset, false);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent deleted) {
        if (this.matchingEvent((AssetEvent)deleted)) {
            this.invalidatePackageRoot((AssetEvent)deleted);
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetUpdatedEvent updated) {
        if (this.matchingEvent((AssetEvent)updated) && this.hasBlobBeenUpdated(updated)) {
            this.invalidatePackageRoot((AssetEvent)updated);
        }
    }

    @Nullable
    @Transactional(retryOn={ONeedRetryException.class}, swallow={ORecordNotFoundException.class})
    protected void doInvalidate(NpmPackageId packageId) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findPackageRootAsset(tx, bucket = tx.findBucket(this.getRepository()), packageId);
        if (Objects.nonNull(asset) && CacheInfo.invalidateAsset((Asset)asset)) {
            tx.saveAsset(asset);
        }
    }

    private Asset getAsset(StorageTx tx, NpmPackageId packageId) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (Objects.isNull(asset)) {
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(packageId.id());
        }
        return asset;
    }

    @VisibleForTesting
    protected boolean shouldServeFirstResult(List<?> packages, NpmPackageId packageId) {
        return packages.size() == 1 || !this.mergeMetadata && StringUtils.isEmpty((CharSequence)packageId.scope());
    }

    @Nullable
    private NestedAttributesMap getNestedAttributesMap(Payload payload) {
        return Objects.nonNull(payload) ? (NestedAttributesMap)((Content)payload).getAttributes().get(NestedAttributesMap.class) : null;
    }

    private static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    private boolean matchingEvent(AssetEvent event) {
        return this.matchesRepository(event) && Objects.isNull(event.getComponentId());
    }

    private boolean matchesRepository(AssetEvent event) {
        return event.isLocal() && this.groupFacet.member(event.getRepositoryName());
    }

    private void invalidatePackageRoot(AssetEvent event) {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            this.doInvalidate(NpmPackageId.parse(event.getAsset().name()));
        }
        finally {
            UnitOfWork.end();
        }
    }

    private boolean hasBlobBeenUpdated(AssetUpdatedEvent updated) {
        DateTime blobUpdated = updated.getAsset().blobUpdated();
        DateTime oneMinuteAgo = DateTime.now().minusMinutes(1);
        return Objects.isNull(blobUpdated) || blobUpdated.isAfter((ReadableInstant)oneMinuteAgo);
    }

    public Iterable<Repository> members() {
        return this.groupFacet.members();
    }
}

