/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.MetadataVersionParser;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.firewall.event.ComponentVersionsRequest;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;

@Named
@Facet.Exposed
public class OrientNonCatalogedVersionHelperFacet
extends FacetSupport {
    public static final String REMOVE_NON_CATALOGED_KEY = "removeNonCataloged";
    public static final String CLM_CAPABILITY_TYPE_ID = "firewall.audit";
    public static final String REPOSITORY_KEY = "repository";
    public static final String CACHE_NAME = "NPM_CATALOGED_VERSIONS";
    private final int limit;
    private final EventManager eventManager;
    private final int componentVersionsTimeout;
    private final CapabilityRegistry capabilityRegistry;
    private final CacheHelper cacheHelper;
    private final long cacheDuration;

    @Inject
    public OrientNonCatalogedVersionHelperFacet(EventManager eventManager, CapabilityRegistry capabilityRegistry, CacheHelper cacheHelper, @Named(value="${nexus.npm.firewall.check_last_limit:-5}") int checkLastLimit, @Named(value="${nexus.npm.firewall.component_versions_timeout:-10}") int componentVersionsTimeout, @Named(value="${nexus.npm.firewall.component_versions_cache_duration:-72}") long cacheDuration) {
        this.eventManager = eventManager;
        this.capabilityRegistry = capabilityRegistry;
        this.cacheHelper = cacheHelper;
        Preconditions.checkArgument((cacheDuration > 0L ? 1 : 0) != 0, (String)"nexus.npm.firewall.component_versions_cache_duration must be > 0. Value was %s", (int)checkLastLimit);
        this.cacheDuration = cacheDuration;
        Preconditions.checkArgument((checkLastLimit > 0 ? 1 : 0) != 0, (String)"nexus.npm.firewall.check_last_limit must be > 0. Value was %s", (int)checkLastLimit);
        this.limit = checkLastLimit;
        Preconditions.checkArgument((componentVersionsTimeout > 0 ? 1 : 0) != 0, (String)"nexus.npm.firewall.component_versions_timeout must be > 0. Value was %s", (int)componentVersionsTimeout);
        this.componentVersionsTimeout = componentVersionsTimeout;
    }

    protected void doStop() {
        this.maybeDestroyCache();
    }

    private Cache<String, List<String>> maybeCreateCache() {
        Duration duration = new Duration(TimeUnit.HOURS, this.cacheDuration);
        Factory expiryPolicyFactory = CreatedExpiryPolicy.factoryOf((Duration)duration);
        MutableConfiguration config = new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(expiryPolicyFactory).setManagementEnabled(true).setStatisticsEnabled(true);
        return this.cacheHelper.maybeCreateCache(this.getCacheName(), config);
    }

    private void maybeDestroyCache() {
        this.cacheHelper.maybeDestroyCache(this.getCacheName());
    }

    private String getCacheName() {
        return String.valueOf(this.getRepository().getName()) + CACHE_NAME;
    }

    public void clearCache() {
        this.maybeDestroyCache();
        this.maybeCreateCache();
    }

    @Guarded(by={"STARTED"})
    public void maybeAddExcludedVersionsFieldMatchers(List<NpmFieldMatcher> fieldMatchers, Asset packageRootAsset, Repository repository) {
        Boolean removeNonCatalogedVersions = (Boolean)repository.getConfiguration().attributes("npm").get(REMOVE_NON_CATALOGED_KEY, Boolean.class);
        if (!Boolean.TRUE.equals(removeNonCatalogedVersions) || !this.isFirewallEnabled(repository)) {
            return;
        }
        try {
            Blob blob;
            BlobRef blobRef = packageRootAsset.blobRef();
            if (blobRef != null && (blob = ((StorageFacet)repository.facet(StorageFacet.class)).blobStore().get(blobRef.getBlobId())) != null) {
                List<String> versions = MetadataVersionParser.readVersions(blob.getInputStream());
                List<String> nonCatalogedVersions = this.nonCatalogedVersions(packageRootAsset.name(), OrientNonCatalogedVersionHelperFacet.last(this.limit, versions));
                List<NpmFieldMatcher> excludeVersions = nonCatalogedVersions.stream().map(v -> NpmFieldFactory.removeObjectFieldMatcher(v, "/versions/" + v)).collect(Collectors.toList());
                this.maybeRewriteLatest(excludeVersions, nonCatalogedVersions, versions);
                fieldMatchers.addAll(excludeVersions);
            }
        }
        catch (Exception e) {
            this.log.warn("Error removing non-cataloged versions from metadata");
            this.log.debug("Error removing non-cataloged versions from metadata", (Throwable)e);
        }
    }

    private boolean isFirewallEnabled(Repository repository) {
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter capabilityReferenceFilter = CapabilityReferenceFilterBuilder.capabilities().withType(new CapabilityType(CLM_CAPABILITY_TYPE_ID)).withProperty(REPOSITORY_KEY, repository.getName()).enabled();
        Collection capabilityReferences = this.capabilityRegistry.get((com.google.common.base.Predicate)capabilityReferenceFilter);
        return !capabilityReferences.isEmpty();
    }

    @VisibleForTesting
    static List<String> last(int n, List<String> versions) {
        if (versions.isEmpty()) {
            return Collections.emptyList();
        }
        return versions.subList(versions.size() > n ? versions.size() - n : 0, versions.size());
    }

    private void maybeRewriteLatest(List<NpmFieldMatcher> excludeVersions, List<String> nonCatalogedVersions, List<String> allVersions) {
        if (excludeVersions.size() > 0) {
            excludeVersions.add(NpmFieldFactory.rewriteLatest(nonCatalogedVersions, allVersions));
        }
    }

    private List<String> nonCatalogedVersions(String packageName, List<String> versions) {
        try {
            Cache<String, List<String>> npmCatalogedVersions = this.maybeCreateCache();
            PackageNameParser parser = new PackageNameParser(packageName);
            PackageUrl packageUrl = PackageUrl.builder().type("npm").namespace(parser.namespace).name(parser.name).build();
            List cachedVersions = (List)npmCatalogedVersions.get((Object)packageUrl.toString());
            if (cachedVersions != null && versions.stream().noneMatch(this.notCataloged(cachedVersions))) {
                return Collections.emptyList();
            }
            ComponentVersionsRequest componentVersionsRequest = new ComponentVersionsRequest(packageUrl);
            this.eventManager.post((Object)componentVersionsRequest);
            List catalogedVersions = (List)componentVersionsRequest.getResult().get(this.componentVersionsTimeout, TimeUnit.SECONDS);
            npmCatalogedVersions.put((Object)packageUrl.toString(), (Object)catalogedVersions);
            List<String> nonCatalogedVersions = versions.stream().filter(this.notCataloged(catalogedVersions)).collect(Collectors.toList());
            if (this.noneAreCataloged(versions, nonCatalogedVersions)) {
                return Collections.emptyList();
            }
            return nonCatalogedVersions;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.log.error("Error getting non cataloged versions for {}", (Object)packageName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private boolean noneAreCataloged(List<String> versions, List<String> nonCatalogedVersions) {
        return versions.size() == nonCatalogedVersions.size();
    }

    private Predicate<String> notCataloged(List<String> catalogedVersions) {
        return version -> !catalogedVersions.contains(version);
    }

    private static class PackageNameParser {
        final String namespace;
        final String name;

        public PackageNameParser(String packageName) {
            String[] namespaceAndName = packageName.split("/", 2);
            this.namespace = namespaceAndName.length == 2 ? namespaceAndName[0] : null;
            this.name = namespaceAndName.length == 2 ? namespaceAndName[1] : namespaceAndName[0];
        }
    }
}

