/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmResponses;
import com.sonatype.nexus.repository.npm.internal.NpmTokenFacet;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import com.sonatype.nexus.repository.npm.internal.security.NpmTokenManager;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
@Priority(value=0x7FFFFFFF)
public class NpmTokenFacetImpl
extends FacetSupport
implements NpmTokenFacet {
    private final NpmTokenManager npmTokenManager;

    @Inject
    public NpmTokenFacetImpl(NpmTokenManager npmTokenManager) {
        this.npmTokenManager = (NpmTokenManager)((Object)Preconditions.checkNotNull((Object)((Object)npmTokenManager)));
    }

    @Override
    public Response login(Context context) {
        Payload payload = context.getRequest().getPayload();
        if (payload == null) {
            return NpmResponses.badRequest("Missing body");
        }
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TempBlob tempBlob = storageFacet.createTempBlob(payload, NpmFacetUtils.HASH_ALGORITHMS);){
                NestedAttributesMap request = NpmJsonUtils.parse((InputStreamSupplier)tempBlob);
                String token = this.npmTokenManager.login((String)request.get("name", String.class), (String)request.get("password", String.class));
                if (token != null) {
                    NestedAttributesMap response = new NestedAttributesMap("response", (Map)Maps.newHashMap());
                    response.set("ok", (Object)Boolean.TRUE.toString());
                    response.set("rev", (Object)"_we_dont_use_revs_any_more");
                    response.set("id", (Object)"org.couchdb.user:undefined");
                    response.set("token", (Object)token);
                    return HttpResponses.created((Payload)new BytesPayload(NpmJsonUtils.bytes(response), "application/json"));
                }
                return NpmResponses.badCredentials("Bad username or password");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response logout(Context context) {
        if (this.npmTokenManager.logout()) {
            NestedAttributesMap response = new NestedAttributesMap("response", (Map)Maps.newHashMap());
            response.set("ok", (Object)Boolean.TRUE.toString());
            return NpmResponses.ok((Payload)new BytesPayload(NpmJsonUtils.bytes(response), "application/json"));
        }
        return NpmResponses.notFound("Token not found");
    }
}

