/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.SingleAssetComponentMaintenance;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Facet.Exposed
public class NpmProxyComponentMaintenanceFacet
extends SingleAssetComponentMaintenance {
    @Transactional
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, tx.findBucket(this.getRepository()));
        NpmAttributes.AssetKind assetKind = NpmAttributes.AssetKind.valueOf((String)asset.formatAttributes().get("asset_kind", String.class));
        if (NpmAttributes.AssetKind.TARBALL == assetKind) {
            NpmPackageId packageId = NpmPackageId.parse(asset.name().substring(0, asset.name().indexOf("/-/")));
            Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
            if (packageRootAsset != null && CacheInfo.invalidateAsset((Asset)packageRootAsset)) {
                tx.saveAsset(packageRootAsset);
            }
        }
        return super.deleteAssetTx(assetId, deleteBlob);
    }
}

