/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.orient.NpmFacetUtils;
import com.sonatype.nexus.repository.npm.internal.orient.OrientNpmHostedFacet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class NpmHostedComponentMaintenanceImpl
extends DefaultComponentMaintenanceImpl {
    @TransactionalDeleteBlob
    protected DefaultComponentMaintenanceImpl.DeletionResult deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(componentId, tx.findBucket(this.getRepository()));
        if (component == null) {
            return new DefaultComponentMaintenanceImpl.DeletionResult(null, Collections.emptySet());
        }
        HashSet deletedAssets = new HashSet();
        tx.browseAssets(component).forEach(a -> {
            boolean bl2 = deletedAssets.addAll(this.deleteAssetTx((Asset)a, deleteBlobs));
        });
        return new DefaultComponentMaintenanceImpl.DeletionResult(component, deletedAssets);
    }

    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        return this.deleteAssetTx(asset, deleteBlob);
    }

    private Set<String> deleteAssetTx(Asset asset, boolean deleteBlob) {
        NpmAttributes.AssetKind assetKind = NpmAttributes.AssetKind.valueOf((String)asset.formatAttributes().get("asset_kind", String.class));
        HashSet<String> deletedAssets = new HashSet<String>();
        try {
            if (NpmAttributes.AssetKind.PACKAGE_ROOT == assetKind) {
                NpmPackageId packageId = NpmPackageId.parse(asset.name());
                deletedAssets.addAll(this.deletePackageRoot(packageId, deleteBlob));
            } else if (NpmAttributes.AssetKind.TARBALL == assetKind) {
                StorageTx tx;
                Component component;
                NpmPackageId packageId = NpmPackageId.parse(asset.name().substring(0, asset.name().indexOf("/-/")));
                String tarballName = NpmMetadataUtils.extractTarballName(asset.name());
                deletedAssets.addAll(this.deleteTarball(packageId, tarballName, deleteBlob));
                EntityId componentId = asset.componentId();
                if (componentId != null && (component = (tx = (StorageTx)UnitOfWork.currentTx()).findComponent(componentId)) != null && !tx.browseAssets(component).iterator().hasNext()) {
                    deletedAssets.addAll(this.deleteComponentTx(componentId, deleteBlob).getAssets());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return deletedAssets;
    }

    private Set<String> deletePackageRoot(NpmPackageId packageId, boolean deleteBlob) throws IOException {
        return ((OrientNpmHostedFacet)this.getRepository().facet(OrientNpmHostedFacet.class)).deletePackage(packageId, null, deleteBlob);
    }

    private Set<String> deleteTarball(NpmPackageId packageId, String tarballName, boolean deleteBlob) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientNpmHostedFacet hostedFacet = (OrientNpmHostedFacet)this.getRepository().facet(OrientNpmHostedFacet.class);
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            this.log.debug("No package root present for asset: {}", (Object)packageId);
            return hostedFacet.deleteTarball(packageId, tarballName, deleteBlob).map(Collections::singleton).orElseGet(Collections::emptySet);
        }
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        NestedAttributesMap versionMap = NpmMetadataUtils.selectVersionByTarballName(packageRoot, tarballName);
        if (versionMap != null) {
            String version = versionMap.getKey();
            packageRoot.child("versions").remove(version);
            NpmFacetUtils.removeDistTagsFromTagsWithVersion(packageRoot, version);
            packageRoot.child("time").remove(version);
        }
        if (packageRoot.child("versions").isEmpty()) {
            return hostedFacet.deletePackage(packageId, null, deleteBlob);
        }
        NpmMetadataUtils.maintainTime(packageRoot);
        NpmFacetUtils.savePackageRoot((StorageTx)UnitOfWork.currentTx(), packageRootAsset, packageRoot);
        return hostedFacet.deleteTarball(packageId, tarballName, deleteBlob).map(Collections::singleton).orElseGet(Collections::emptySet);
    }
}

