/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import com.sonatype.nexus.repository.npm.internal.orient.NpmContent;
import com.sonatype.nexus.repository.npm.internal.orient.NpmStreamPayload;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.MissingAssetBlobException;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.thread.io.StreamCopier;

public final class NpmFacetUtils {
    private static final String SQL_FIND_ALL_PACKAGE_NAMES = String.format("SELECT DISTINCT(%s) AS %s FROM asset WHERE %s = :bucketRid AND %s.%s.%s = :kind ORDER BY name", "name", "name", "bucket", "attributes", "npm", "asset_kind");
    public static final List<HashAlgorithm> HASH_ALGORITHMS = Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1});
    public static final String REPOSITORY_ROOT_ASSET = "-/all";
    public static final String REPOSITORY_SEARCH_ASSET = "-/v1/search";

    private NpmFacetUtils() {
    }

    @Nonnull
    static NestedAttributesMap parse(InputStreamSupplier streamSupplier) throws IOException {
        return NpmJsonUtils.parse(streamSupplier);
    }

    @Nonnull
    static AssetBlob storeContent(StorageTx tx, Asset asset, InputStreamSupplier content, NpmAttributes.AssetKind assetKind) throws IOException {
        asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        AssetBlob result = tx.createBlob(asset.name(), content, HASH_ALGORITHMS, null, assetKind.getContentType(), assetKind.isSkipContentVerification());
        tx.attachBlob(asset, result);
        return result;
    }

    @Nonnull
    static AssetBlob storeContent(StorageTx tx, Asset asset, TempBlob tempBlob, NpmAttributes.AssetKind assetKind) throws IOException {
        asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        AssetBlob result = tx.createBlob(asset.name(), tempBlob, null, assetKind.getContentType(), assetKind.isSkipContentVerification());
        tx.attachBlob(asset, result);
        return result;
    }

    public static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    public static NpmContent toContent(Repository repository, Asset packageRootAsset) {
        NpmContent content = new NpmContent(NpmFacetUtils.toPayload(repository, packageRootAsset));
        Content.extractFromAsset((Asset)packageRootAsset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    public static NpmStreamPayload toPayload(Repository repository, Asset packageRootAsset) {
        return new NpmStreamPayload(NpmFacetUtils.loadPackageRoot(repository, packageRootAsset));
    }

    @Nonnull
    public static Content saveRepositoryRoot(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, Content content) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes()));
        AssetBlob assetBlob = NpmFacetUtils.storeContent(tx, asset, contentSupplier, NpmAttributes.AssetKind.REPOSITORY_ROOT);
        tx.saveAsset(asset);
        return NpmFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    @Nonnull
    static Content saveRepositoryRoot(StorageTx tx, Asset asset, TempBlob tempBlob, Content content) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes()));
        AssetBlob assetBlob = NpmFacetUtils.storeContent(tx, asset, tempBlob, NpmAttributes.AssetKind.REPOSITORY_ROOT);
        tx.saveAsset(asset);
        return NpmFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    @Nonnull
    static String tarballAssetName(NpmPackageId packageId, String tarballName) {
        return String.valueOf(packageId.id()) + "/-/" + tarballName;
    }

    @Nonnull
    private static Query.Builder query(NpmPackageId packageId) {
        if (packageId.scope() != null) {
            return Query.builder().where("name").eq((Object)packageId.name()).and("group").eq((Object)packageId.scope());
        }
        return Query.builder().where("name").eq((Object)packageId.name()).and("group").isNull();
    }

    @Nonnull
    static Iterable<Component> findPackageTarballComponents(StorageTx tx, Repository repository, NpmPackageId packageId) {
        return tx.findComponents(NpmFacetUtils.query(packageId).build(), Collections.singletonList(repository));
    }

    @Nullable
    static Component findPackageTarballComponent(StorageTx tx, Repository repository, NpmPackageId packageId, String version) {
        Iterable components = tx.findComponents(NpmFacetUtils.query(packageId).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    public static Asset findRepositoryRootAsset(StorageTx tx, Bucket bucket) {
        return tx.findAssetWithProperty("name", (Object)REPOSITORY_ROOT_ASSET, bucket);
    }

    @Nullable
    public static Asset findPackageRootAsset(StorageTx tx, Bucket bucket, NpmPackageId packageId) {
        return tx.findAssetWithProperty("name", (Object)packageId.id(), bucket);
    }

    @Nullable
    static Asset findTarballAsset(StorageTx tx, Bucket bucket, NpmPackageId packageId, String tarballName) {
        return tx.findAssetWithProperty("name", (Object)NpmFacetUtils.tarballAssetName(packageId, tarballName), bucket);
    }

    @Nonnull
    public static Iterable<NpmPackageId> findAllPackageNames(StorageTx tx, Bucket bucket) {
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        sqlParams.put("bucketRid", AttachedEntityHelper.id((Entity)bucket));
        sqlParams.put("kind", (Object)NpmAttributes.AssetKind.PACKAGE_ROOT);
        return Iterables.transform((Iterable)tx.browse(SQL_FIND_ALL_PACKAGE_NAMES, sqlParams), input -> NpmPackageId.parse((String)input.field("name", OType.STRING)));
    }

    public static NestedAttributesMap loadPackageRoot(StorageTx tx, Asset packageRootAsset) throws IOException {
        Blob blob = tx.requireBlob(packageRootAsset.requireBlobRef());
        NestedAttributesMap metadata = NpmJsonUtils.parse(() -> ((Blob)blob).getInputStream());
        metadata.set("_id", (Object)packageRootAsset.name());
        return metadata;
    }

    public static InputStreamSupplier loadPackageRoot(Repository repository, Asset packageRootAsset) {
        return () -> NpmFacetUtils.packageRootAssetToInputStream(repository, packageRootAsset);
    }

    public static InputStream errorInputStream(String message) {
        NestedAttributesMap errorObject = new NestedAttributesMap("error", (Map)Maps.newHashMap());
        errorObject.set("success", (Object)false);
        errorObject.set("error", (Object)("Failed to stream response due to: " + message));
        return new ByteArrayInputStream(NpmJsonUtils.bytes(errorObject));
    }

    public static void savePackageRoot(StorageTx tx, Asset packageRootAsset, NestedAttributesMap packageRoot) throws IOException {
        packageRoot.remove("_id");
        packageRoot.remove("_attachments");
        packageRootAsset.formatAttributes().set("last_modified", (Object)NpmMetadataUtils.maintainTime(packageRoot).toDate());
        NpmFacetUtils.storeContent(tx, packageRootAsset, (InputStreamSupplier)new StreamCopier(outputStream -> NpmJsonUtils.serialize(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8), packageRoot), inputStream -> () -> inputStream).read(), NpmAttributes.AssetKind.PACKAGE_ROOT);
        tx.saveAsset(packageRootAsset);
    }

    public static Set<String> deletePackageRoot(StorageTx tx, Repository repository, NpmPackageId packageId, boolean deleteBlobs) {
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(repository), packageId);
        if (packageRootAsset == null) {
            return Collections.emptySet();
        }
        tx.deleteAsset(packageRootAsset, deleteBlobs);
        Iterable<Component> npmTarballs = NpmFacetUtils.findPackageTarballComponents(tx, repository, packageId);
        HashSet<String> deletedAssetNames = new HashSet<String>();
        for (Component npmTarball : npmTarballs) {
            deletedAssetNames.addAll(tx.deleteComponent(npmTarball, deleteBlobs));
        }
        return deletedAssetNames;
    }

    static Optional<String> deleteTarball(StorageTx tx, Repository repository, NpmPackageId packageId, String tarballName, boolean deleteBlob) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        Bucket bucket = tx.findBucket(repository);
        Asset tarballAsset = NpmFacetUtils.findTarballAsset(tx, bucket, packageId, tarballName);
        if (tarballAsset == null) {
            return Optional.empty();
        }
        Component tarballComponent = tx.findComponentInBucket(tarballAsset.componentId(), bucket);
        if (tarballComponent == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((String)Iterables.getOnlyElement((Iterable)tx.deleteComponent(tarballComponent, deleteBlob), null));
    }

    static Optional<Content> getTarballContent(StorageTx tx, Bucket bucket, NpmPackageId packageId, String tarballName) {
        Asset asset = NpmFacetUtils.findTarballAsset(tx, bucket, packageId, tarballName);
        if (asset == null) {
            return Optional.empty();
        }
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return Optional.of(content);
    }

    @Nonnull
    static Component getOrCreateTarballComponent(StorageTx tx, Repository repository, NpmPackageId packageId, String version) {
        Component tarballComponent = NpmFacetUtils.findPackageTarballComponent(tx, repository, packageId, version);
        if (tarballComponent == null) {
            tarballComponent = ((Component)tx.createComponent(tx.findBucket(repository), repository.getFormat()).group(packageId.scope()).name(packageId.name())).version(version);
            tx.saveComponent(tarballComponent);
        }
        return tarballComponent;
    }

    static AssetBlob createTarballAssetBlob(StorageTx tx, NpmPackageId packageId, String tarballName, TempBlob tempBlob) throws IOException {
        return tx.createBlob(NpmFacetUtils.tarballAssetName(packageId, tarballName), tempBlob, null, NpmAttributes.AssetKind.TARBALL.getContentType(), NpmAttributes.AssetKind.TARBALL.isSkipContentVerification());
    }

    static AssetBlob createTarballAssetBlob(StorageTx tx, NpmPackageId packageId, String tarballName, AssetBlob blob) throws IOException {
        InputStreamSupplier is = () -> blob.getBlob().getInputStream();
        return tx.createBlob(NpmFacetUtils.tarballAssetName(packageId, tarballName), is, blob.getHashes().keySet(), null, NpmAttributes.AssetKind.TARBALL.getContentType(), NpmAttributes.AssetKind.TARBALL.isSkipContentVerification());
    }

    private static InputStream packageRootAssetToInputStream(Repository repository, Asset packageRootAsset) {
        BlobStore blobStore = ((StorageFacet)repository.facet(StorageFacet.class)).blobStore();
        if (Objects.isNull(blobStore)) {
            throw new MissingAssetBlobException(packageRootAsset);
        }
        BlobRef blobRef = packageRootAsset.requireBlobRef();
        Blob blob = blobStore.get(blobRef.getBlobId());
        if (Objects.isNull(blob)) {
            throw new MissingAssetBlobException(packageRootAsset);
        }
        try {
            return blob.getInputStream();
        }
        catch (BlobStoreException blobStoreException) {
            throw new MissingAssetBlobException(packageRootAsset);
        }
    }

    public static Content distTagsToContent(NestedAttributesMap distTags) throws IOException {
        byte[] bytes = NpmJsonUtils.mapper.writeValueAsBytes((Object)distTags.backing());
        return new Content((Payload)new BytesPayload(bytes, "application/json"));
    }

    public static void updateDistTags(StorageTx tx, Asset packageRootAsset, String tag, Object version) throws IOException {
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        NestedAttributesMap distTags = packageRoot.child("dist-tags");
        distTags.set(tag, version);
        NpmFacetUtils.savePackageRoot(tx, packageRootAsset, packageRoot);
    }

    public static void deleteDistTags(StorageTx tx, Asset packageRootAsset, String tag) throws IOException {
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        if (packageRoot.contains("dist-tags")) {
            NestedAttributesMap distTags = packageRoot.child("dist-tags");
            distTags.remove(tag);
            NpmFacetUtils.savePackageRoot(tx, packageRootAsset, packageRoot);
        }
    }

    public static void removeDistTagsFromTagsWithVersion(NestedAttributesMap packageRoot, String version) {
        if (packageRoot.contains("dist-tags")) {
            packageRoot.child("dist-tags").entries().removeIf(e -> version.equals(e.getValue()));
            Set versions = ((Map)packageRoot.backing().get("versions")).keySet();
            String latest = versions.stream().max(new VersionComparator()).orElse("");
            packageRoot.child("dist-tags").set("latest", (Object)latest);
        }
    }

    public static Response mergeDistTagResponse(Map<Repository, Response> responses) throws IOException {
        List collection = responses.values().stream().map(Response::getPayload).filter(Objects::nonNull).map(NpmFacetUtils::readDistTagResponse).filter(Objects::nonNull).collect(Collectors.toList());
        NestedAttributesMap merged = (NestedAttributesMap)collection.get(0);
        if (collection.size() > 1) {
            collection.subList(1, collection.size()).forEach(response -> response.backing().forEach(NpmFacetUtils.populateLatestVersion(merged)));
        }
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new BytesPayload(NpmJsonUtils.bytes(merged), "application/json")).build();
    }

    private static BiConsumer<String, Object> populateLatestVersion(NestedAttributesMap merged) {
        return (k, v) -> {
            if (!merged.contains(k)) {
                merged.set(k, v);
            } else {
                String newestVersion = NpmVersionComparator.extractNewestVersion.apply((String)merged.get(k, String.class), (String)v);
                merged.set(k, (Object)newestVersion);
            }
        };
    }

    private static NestedAttributesMap readDistTagResponse(Payload payload) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Payload p = payload;){
                return NpmJsonUtils.parse(() -> ((Payload)p).openInputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

