/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.browse.AssetPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="npm")
public class NpmBrowseNodeGenerator
extends AssetPathBrowseNodeGenerator {
    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        List nameParts = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)asset.name());
        String assetName = (String)nameParts.get(nameParts.size() - 1);
        return super.computeAssetPaths(asset, component).stream().filter(paths -> !"-".equals(paths.getDisplayName())).map(path -> NpmBrowseNodeGenerator.renameIfHashed(path, assetName, asset, component)).collect(Collectors.toList());
    }

    private static BrowsePaths renameIfHashed(BrowsePaths path, String assetName, Asset asset, Component component) {
        if (NpmBrowseNodeGenerator.isHash(path.getDisplayName()) && path.getDisplayName().equals(assetName) && component != null) {
            return new BrowsePaths(NpmBrowseNodeGenerator.buildDisplayName(component, asset).orElse(path.getDisplayName()), path.getRequestPath());
        }
        return path;
    }

    private static Optional<String> buildDisplayName(Component component, Asset asset) {
        return Optional.ofNullable((String)asset.formatAttributes().get("name", String.class)).map(npmName -> StringUtils.removeStart((String)npmName, (String)"@").replaceAll("[@/]+", "-")).map(formattedName -> String.format("%s-%s.tgz", formattedName, component.version()));
    }

    private static boolean isHash(String tarballName) {
        return !tarballName.endsWith(".tgz") && !tarballName.endsWith(".tar.gz");
    }
}

