/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.audit.report;

import com.google.common.collect.Sets;
import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import com.sonatype.nexus.repository.npm.internal.audit.parser.PackageLock;
import com.sonatype.nexus.repository.npm.internal.audit.parser.PackageLockNode;
import com.sonatype.nexus.repository.npm.internal.audit.report.Action;
import com.sonatype.nexus.repository.npm.internal.audit.report.ActionType;
import com.sonatype.nexus.repository.npm.internal.audit.report.Advisory;
import com.sonatype.nexus.repository.npm.internal.audit.report.Finding;
import com.sonatype.nexus.repository.npm.internal.audit.report.Metadata;
import com.sonatype.nexus.repository.npm.internal.audit.report.Resolve;
import com.sonatype.nexus.repository.npm.internal.audit.report.ResponseReport;
import com.sonatype.nexus.repository.npm.internal.audit.report.VulnerabilityReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.firewall.event.QuarantinedComponentVersions;
import org.sonatype.nexus.repository.vulnerability.AuditComponent;
import org.sonatype.nexus.repository.vulnerability.AuditRepositoryComponent;
import org.sonatype.nexus.repository.vulnerability.ComponentsVulnerability;
import org.sonatype.nexus.repository.vulnerability.SeverityLevel;
import org.sonatype.nexus.repository.vulnerability.Vulnerability;

@Named
@Singleton
public class ReportCreator {
    private static final String N_A = "N/A";
    private static final String APP_ID_ADVICE = "Please specify an APP_ID following the instructions" + System.lineSeparator() + "https://links.sonatype.com/npm-audit";
    private static final Logger log = LoggerFactory.getLogger(ReportCreator.class);
    private static final int MAX_DISPLAY_QUARANTINE_VERSIONS = 20;

    public ResponseReport buildResponseReport(ComponentsVulnerability report, PackageLock packageLock, String applicationId, QuarantinedComponentVersions quarantinedComponentVersions) {
        ArrayList<Action> actions = new ArrayList<Action>();
        HashMap<String, Advisory> advisories = new HashMap<String, Advisory>();
        ArrayList<Object> muted = new ArrayList<Object>();
        int index = 1;
        for (Map.Entry entry : report.getAuditComponents().entrySet()) {
            AuditComponent component = (AuditComponent)entry.getKey();
            List vulnerabilities = (List)entry.getValue();
            vulnerabilities.sort(Comparator.comparing(Vulnerability::getSeverity, Comparator.comparingInt(v -> (Integer)v.getSeverityRange().getMinimum())).reversed());
            for (Vulnerability vulnerability : vulnerabilities) {
                List<Resolve> resolvesForOneComponent = packageLock.createResolve(index, component.getName(), component.getVersion());
                if (resolvesForOneComponent.isEmpty()) {
                    log.warn("NPM component not found: {}", (Object)(String.valueOf(component.getName()) + "-" + component.getVersion()));
                }
                String patchedVersion = StringUtils.isBlank((String)vulnerability.getPatchedIn()) ? N_A : vulnerability.getPatchedIn();
                boolean isAppIdAvailable = StringUtils.isNotBlank((String)applicationId);
                List<String> paths = resolvesForOneComponent.stream().map(Resolve::getPath).collect(Collectors.toList());
                Advisory advisory = this.createAdvisory(index, component, vulnerability, patchedVersion, isAppIdAvailable);
                advisories.put(String.valueOf(index), advisory);
                resolvesForOneComponent.forEach(resolve -> {
                    boolean bl = actions.add(this.createAction(component, (Resolve)resolve, patchedVersion));
                });
                Set<Finding> findings = advisory.getFindings();
                Finding finding = new Finding(component.getVersion(), paths);
                findings.add(finding);
                ++index;
            }
        }
        this.createQuarantineComponentVersionAdvisories(packageLock, quarantinedComponentVersions, actions, advisories, index);
        VulnerabilityReport vulnerabilityReport = this.createVulnerabilityReport(new ArrayList<Advisory>(advisories.values()));
        Metadata metadata = this.createMetadata(vulnerabilityReport, packageLock, applicationId);
        return new ResponseReport(actions, advisories, muted, metadata);
    }

    private void createQuarantineComponentVersionAdvisories(PackageLock packageLock, QuarantinedComponentVersions quarantinedComponentVersions, List<Action> actions, Map<String, Advisory> advisories, int index) {
        if (quarantinedComponentVersions == null) {
            return;
        }
        for (Map.Entry entry : quarantinedComponentVersions.getAuditRepositoryComponents().entrySet()) {
            List versionsQuarantined = (List)entry.getValue();
            if (versionsQuarantined.isEmpty()) continue;
            AuditRepositoryComponent component = (AuditRepositoryComponent)entry.getKey();
            String pathname = component.getPathname();
            String version = NpmCoordinateUtil.extractVersion(pathname);
            String npmPackageId = NpmCoordinateUtil.extractFullName(pathname);
            List quarantinedVersions = versionsQuarantined.stream().map(path -> NpmCoordinateUtil.extractVersion(path)).collect(Collectors.toList());
            String moreInfo = quarantinedVersions.size() > 20 ? "Many versions are quarantined. See the IQ Server repository report for full details." : "Quarantined versions: " + quarantinedVersions;
            Advisory advisory = new Advisory(Sets.newHashSet(), index, "Found " + versionsQuarantined.size() + " quarantined versions excluded from the repository", npmPackageId, N_A, String.valueOf(versionsQuarantined.size()) + " excluded from metadata", SeverityLevel.LOW, SeverityLevel.LOW.getNpmLevel(), moreInfo);
            advisories.put(String.valueOf(index), advisory);
            List<Resolve> resolves = packageLock.createResolve(index, npmPackageId, version);
            resolves.forEach(resolve -> {
                boolean bl = actions.add(this.createAction(new AuditComponent(null, "npm", npmPackageId, version), (Resolve)resolve, N_A));
            });
            Set<Finding> findings = advisory.getFindings();
            Finding finding = new Finding(version, Arrays.asList(npmPackageId));
            findings.add(finding);
            ++index;
        }
    }

    private Metadata createMetadata(VulnerabilityReport vulnerabilityReport, PackageLock packageLock, String applicationId) {
        int dependencies = 0;
        int devDependencies = 0;
        int optionalDependencies = 0;
        for (AuditComponent component : packageLock.getComponents(applicationId)) {
            for (PackageLockNode node : packageLock.getNodes(component.getName(), component.getVersion())) {
                if (!node.isDev()) {
                    ++dependencies;
                } else {
                    ++devDependencies;
                }
                if (!node.isOptional()) continue;
                ++optionalDependencies;
            }
        }
        return new Metadata(vulnerabilityReport, dependencies, devDependencies, optionalDependencies, dependencies + devDependencies);
    }

    private Action createAction(AuditComponent auditComponent, Resolve resolve, String patchedVersion) {
        ActionType actionType = this.getActionType(resolve, patchedVersion);
        return new Action(false, actionType.getType(), Collections.singletonList(resolve), auditComponent.getName(), patchedVersion, resolve.getPathList().size());
    }

    private VulnerabilityReport createVulnerabilityReport(List<Advisory> advisories) {
        int low = 0;
        int moderate = 0;
        int high = 0;
        int critical = 0;
        for (Advisory advisory : advisories) {
            switch (advisory.getSeverityLevel()) {
                case LOW: {
                    low += this.getAdvisoryCount(advisory);
                    break;
                }
                case MODERATE: {
                    moderate += this.getAdvisoryCount(advisory);
                    break;
                }
                case HIGH: {
                    high += this.getAdvisoryCount(advisory);
                    break;
                }
                case CRITICAL: {
                    critical += this.getAdvisoryCount(advisory);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported enum for " + advisory.getSeverityLevel());
                }
            }
        }
        return new VulnerabilityReport(0, low, moderate, high, critical);
    }

    private int getAdvisoryCount(Advisory advisory) {
        return advisory.getFindings().stream().map(a -> a.getPaths().size()).reduce(0, Integer::sum);
    }

    private Advisory createAdvisory(int index, AuditComponent auditComponent, Vulnerability vulnerability, String patchedVersion, boolean isAppIdAvailable) {
        String patchedVersionAdvisory = !isAppIdAvailable && N_A.equals(patchedVersion) ? APP_ID_ADVICE : patchedVersion;
        return new Advisory(Sets.newHashSet(), index, vulnerability.getDescription(), auditComponent.getName(), patchedVersionAdvisory, vulnerability.getDescription(), vulnerability.getSeverity(), vulnerability.getSeverity().getNpmLevel(), vulnerability.getMoreInfo());
    }

    private ActionType getActionType(Resolve resolve, String patchedVersion) {
        ActionType actionType = N_A.equals(patchedVersion) ? ActionType.REVIEW : (resolve.isDev() ? ActionType.UPDATE : ActionType.INSTALL);
        return actionType;
    }
}

