/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal.audit.report;

import com.google.gson.annotations.SerializedName;
import com.sonatype.nexus.repository.npm.internal.audit.report.VulnerabilityReport;
import java.util.Objects;

public class Metadata {
    private final VulnerabilityReport vulnerabilities;
    private final int dependencies;
    @SerializedName(value="devDependencies")
    private final int devDependencies;
    @SerializedName(value="optionalDependencies")
    private final int optionalDependencies;
    @SerializedName(value="totalDependencies")
    private final int totalDependencies;

    public Metadata(VulnerabilityReport vulnerabilities, int dependencies, int devDependencies, int optionalDependencies, int totalDependencies) {
        this.vulnerabilities = vulnerabilities;
        this.dependencies = dependencies;
        this.devDependencies = devDependencies;
        this.optionalDependencies = optionalDependencies;
        this.totalDependencies = totalDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return this.dependencies == metadata.dependencies && this.devDependencies == metadata.devDependencies && this.optionalDependencies == metadata.optionalDependencies && this.totalDependencies == metadata.totalDependencies && Objects.equals(this.vulnerabilities, metadata.vulnerabilities);
    }

    public int hashCode() {
        return Objects.hash(this.vulnerabilities, this.dependencies, this.devDependencies, this.optionalDependencies, this.totalDependencies);
    }

    public String toString() {
        return String.format("dep [%d] dev dep [%d] optional dep [%d] total dep [%d]; vulnerabilities: %s", this.dependencies, this.devDependencies, this.optionalDependencies, this.totalDependencies, this.vulnerabilities);
    }
}

