/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.NpmFieldDeserializer;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.json.UntypedObjectDeserializerSerializer;

public class NpmUntypedObjectDeserializerSerializer
extends UntypedObjectDeserializerSerializer {
    private final List<NpmFieldMatcher> matchers;

    public NpmUntypedObjectDeserializerSerializer(JsonGenerator generator, List<NpmFieldMatcher> matchers) {
        super(generator);
        this.matchers = (List)Preconditions.checkNotNull(matchers);
    }

    @Nullable
    public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String fieldName = parser.getCurrentName();
        for (NpmFieldMatcher matcher : this.matchers) {
            if (!matcher.matches(parser) || !matcher.allowDeserializationOnMatched()) continue;
            NpmFieldDeserializer deserializer = matcher.getDeserializer();
            if (deserializer instanceof NpmFieldFactory.SkipObjectNpmFieldDeserializer) {
                return deserializer.deserialize(fieldName, null, parser, context, this.generator);
            }
            Object defaultValue = this.defaultValueDeserialize(parser, context);
            return deserializer.deserialize(fieldName, defaultValue, parser, context, this.generator);
        }
        return this.defaultDeserialize(fieldName, parser, context);
    }
}

