/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.sonatype.nexus.repository.npm.internal.NpmFieldDeserializer;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmFieldUnmatcher;
import com.sonatype.nexus.repository.npm.internal.NpmMapDeserializerSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.json.SourceMapDeserializer;
import org.sonatype.nexus.repository.json.StreamingObjectMapper;

public class NpmStreamingObjectMapper
extends StreamingObjectMapper {
    private final String packageId;
    private final String packageRev;
    private List<NpmFieldMatcher> matchers;

    public NpmStreamingObjectMapper() {
        this(null, null, Collections.emptyList());
    }

    public NpmStreamingObjectMapper(List<NpmFieldMatcher> matchers) {
        this(null, null, matchers);
    }

    public NpmStreamingObjectMapper(@Nullable String packageId, @Nullable String packageRev, List<NpmFieldMatcher> matchers) {
        this.packageId = packageId;
        this.packageRev = packageRev;
        this.matchers = matchers;
    }

    protected void deserializeAndSerialize(JsonParser parser, DeserializationContext context, MapDeserializer deserializer, JsonGenerator generator) throws IOException {
        SourceMapDeserializer.of((MapDeserializer)new NpmMapDeserializerSerializer(deserializer, generator, this.matchers)).deserialize(parser, context);
    }

    protected void beforeDeserialize(JsonGenerator generator) throws IOException {
        super.beforeDeserialize(generator);
        this.maybeWritePackageAndRevID(generator);
    }

    protected void afterDeserialize(JsonGenerator generator) throws IOException {
        super.afterDeserialize(generator);
        this.appendFieldsIfNeverMatched(generator);
    }

    private void appendFieldsIfNeverMatched(JsonGenerator generator) throws IOException {
        for (NpmFieldMatcher npmFieldMatcher : this.unmatched()) {
            NpmFieldDeserializer deserializer = npmFieldMatcher.getDeserializer();
            generator.writeFieldName(npmFieldMatcher.getFieldName());
            generator.writeObject(deserializer.deserializeValue(null));
        }
    }

    private void maybeWritePackageAndRevID(JsonGenerator generator) throws IOException {
        if (Objects.nonNull(this.packageId)) {
            generator.writeFieldName("_id");
            generator.writeObject((Object)this.packageId);
        }
        if (Objects.nonNull(this.packageRev)) {
            generator.writeFieldName("_rev");
            generator.writeObject((Object)this.packageRev);
        }
    }

    private List<NpmFieldUnmatcher> unmatched() {
        return this.matchers.stream().map(this::npmFieldUnmatchedFilter).filter(Objects::nonNull).filter(NpmFieldUnmatcher::wasNeverMatched).collect(Collectors.toList());
    }

    private NpmFieldUnmatcher npmFieldUnmatchedFilter(NpmFieldMatcher fieldMatcher) {
        return fieldMatcher instanceof NpmFieldUnmatcher ? (NpmFieldUnmatcher)fieldMatcher : null;
    }
}

