/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public final class NpmResponses {
    private static final String DELIMITER = "==================================================================";
    private static final Payload successPayload = NpmResponses.statusPayload(true, null);

    private NpmResponses() {
    }

    private static Payload statusPayload(boolean success, @Nullable String error) {
        NestedAttributesMap errorObject = new NestedAttributesMap("error", (Map)Maps.newHashMap());
        errorObject.set("success", (Object)success);
        if (error != null) {
            errorObject.set("error", (Object)error);
        }
        return new BytesPayload(NpmJsonUtils.bytes(errorObject), "application/json");
    }

    @Nonnull
    static Response ok() {
        return HttpResponses.ok((Payload)successPayload);
    }

    @Nonnull
    public static Response ok(@Nonnull Payload payload) {
        return HttpResponses.ok((Payload)((Payload)Preconditions.checkNotNull((Object)payload)));
    }

    @Nonnull
    public static Response notFound(@Nullable String message) {
        return NpmResponses.failureWithStatusPayload(404, message);
    }

    @Nonnull
    static Response packageNotFound(NpmPackageId packageId) {
        Preconditions.checkNotNull((Object)packageId);
        return NpmResponses.notFound("Package '" + packageId + "' not found");
    }

    @Nonnull
    static Response tarballNotFound(NpmPackageId packageId, String tarballName) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        return NpmResponses.notFound("Tarball '" + tarballName + "' in package '" + packageId + "' not found");
    }

    @Nonnull
    public static Response badRequest(@Nullable String message) {
        return NpmResponses.failureWithStatusPayload(400, message);
    }

    @Nonnull
    public static Response badCredentials(@Nullable String message) {
        return NpmResponses.failureWithStatusPayload(401, message);
    }

    @Nonnull
    public static Response forbidden(@Nullable String message) {
        return NpmResponses.failureWithStatusPayload(403, message);
    }

    @Nonnull
    public static Response failureWithStatusPayload(int code, @Nullable String message) {
        return new Response.Builder().status(Status.failure((int)code)).payload(NpmResponses.statusPayload(false, message)).build();
    }

    @Nonnull
    static Response npmErrorAuditResponse(int statusCode, @Nonnull String message) {
        String newLineDelimiter = String.format("%s%s", System.lineSeparator(), DELIMITER);
        String errorMsg = String.format("%s%s%s%s", newLineDelimiter, System.lineSeparator(), message, newLineDelimiter);
        return new Response.Builder().status(Status.failure((int)statusCode)).payload((Payload)new StringPayload(errorMsg, "application/json")).build();
    }
}

