/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.npm.internal.MetadataVersionParser;
import com.sonatype.nexus.repository.npm.internal.NpmFieldFactory;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.firewall.event.QuarantineComponentsRequestEvent;

@Facet.Exposed
public abstract class NpmQuarantinedVersionFacet
extends FacetSupport {
    public static final String REMOVE_QUARANTINED_KEY = "removeQuarantinedVersions";
    public static final String CLM_CAPABILITY_TYPE_ID = "firewall.audit";
    public static final String REPOSITORY_KEY = "repository";
    public static final String CACHE_NAME = "NPM_FIREWALL_ALLOWED_VERSIONS";
    private final EventManager eventManager;
    private final int quarantinedVersionsTimeoutInSeconds;
    private final CapabilityRegistry capabilityRegistry;
    private final CacheHelper cacheHelper;
    private final long cacheDurationInHours;

    public NpmQuarantinedVersionFacet(EventManager eventManager, CapabilityRegistry capabilityRegistry, CacheHelper cacheHelper, int quarantinedVersionsTimeoutInSeconds, long cacheDuration) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.cacheHelper = (CacheHelper)Preconditions.checkNotNull((Object)cacheHelper);
        Preconditions.checkArgument((cacheDuration > 0L ? 1 : 0) != 0, (String)"nexus.npm.firewall.quarantined_versions_cache_duration must be > 0. Value was %s", (long)cacheDuration);
        this.cacheDurationInHours = cacheDuration;
        Preconditions.checkArgument((quarantinedVersionsTimeoutInSeconds > 0 ? 1 : 0) != 0, (String)"nexus.npm.firewall.quarantined_versions_timeout must be > 0. Value was %s", (int)quarantinedVersionsTimeoutInSeconds);
        this.quarantinedVersionsTimeoutInSeconds = quarantinedVersionsTimeoutInSeconds;
    }

    protected void doStop() {
        this.maybeDestroyCache();
    }

    private Cache<String, List<String>> maybeCreateCache() {
        Duration duration = new Duration(TimeUnit.HOURS, this.cacheDurationInHours);
        Factory expiryPolicyFactory = CreatedExpiryPolicy.factoryOf((Duration)duration);
        MutableConfiguration config = new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(expiryPolicyFactory).setManagementEnabled(true).setStatisticsEnabled(true);
        return this.cacheHelper.maybeCreateCache(this.getCacheName(), config);
    }

    private void maybeDestroyCache() {
        this.cacheHelper.maybeDestroyCache(this.getCacheName());
    }

    private String getCacheName() {
        return String.valueOf(this.getRepository().getName()) + CACHE_NAME;
    }

    public void clearCache() {
        this.maybeDestroyCache();
        this.maybeCreateCache();
    }

    @Guarded(by={"STARTED"})
    public void maybeAddExcludedVersionsFieldMatchers(List<NpmFieldMatcher> fieldMatchers, NpmPackageId packageId, BlobRef blobRef, Repository repository) {
        Boolean removeQuarantinedVersions = (Boolean)repository.getConfiguration().attributes("npm").get(REMOVE_QUARANTINED_KEY, Boolean.class);
        if (!Boolean.TRUE.equals(removeQuarantinedVersions) || !this.isFirewallEnabled(repository)) {
            return;
        }
        if (blobRef != null) {
            try {
                this.removeQuarantinedComponents(packageId, fieldMatchers, this.getBlob(blobRef), repository);
            }
            catch (Exception e) {
                this.log.warn("Error removing quarantined versions from metadata", (Throwable)(this.log.isDebugEnabled() ? e : null));
            }
        }
    }

    public abstract Optional<Blob> getBlob(BlobRef var1);

    private void removeQuarantinedComponents(NpmPackageId packageId, List<NpmFieldMatcher> fieldMatchers, Optional<Blob> blob, Repository repository) throws IOException {
        if (blob.isPresent()) {
            Map<String, String> versionHashes = MetadataVersionParser.readVersionHashes(blob.get().getInputStream());
            List<QuarantineComponentsRequestEvent.FirewallComponent> components = this.buildFirewallComponents(versionHashes, packageId);
            ArrayList<String> versions = new ArrayList<String>(versionHashes.keySet());
            List<String> quarantinedVersions = this.getQuarantinedVersions(packageId, repository, versions, components);
            List<NpmFieldMatcher> excludeVersions = quarantinedVersions.stream().map(v -> NpmFieldFactory.removeObjectFieldMatcher(v, "/versions/" + v)).collect(Collectors.toList());
            this.maybeRewriteLatest(excludeVersions, quarantinedVersions, versions);
            fieldMatchers.addAll(excludeVersions);
        }
    }

    private List<QuarantineComponentsRequestEvent.FirewallComponent> buildFirewallComponents(Map<String, String> versionHashes, NpmPackageId packageId) {
        return versionHashes.entrySet().stream().filter(versionHash -> versionHash.getKey() != null).map(versionHash -> new QuarantineComponentsRequestEvent.FirewallComponent((String)versionHash.getValue(), NpmContentFacet.tarballPath(packageId, (String)versionHash.getKey()), (String)versionHash.getKey())).collect(Collectors.toList());
    }

    private List<String> getQuarantinedVersions(NpmPackageId packageId, Repository repository, List<String> versions, List<QuarantineComponentsRequestEvent.FirewallComponent> components) {
        try {
            Cache<String, List<String>> npmAllowedVersions = this.maybeCreateCache();
            List cachedVersions = (List)npmAllowedVersions.get((Object)packageId.id());
            if (cachedVersions != null && versions.stream().noneMatch(this.quarantined(cachedVersions))) {
                return Collections.emptyList();
            }
            QuarantineComponentsRequestEvent request = new QuarantineComponentsRequestEvent(repository, components);
            this.eventManager.post((Object)request);
            List quarantinedPaths = (List)request.getResult().get(this.quarantinedVersionsTimeoutInSeconds, TimeUnit.SECONDS);
            ArrayList<String> quarantinedVersions = new ArrayList<String>();
            ArrayList<String> allowedVersions = new ArrayList<String>();
            for (QuarantineComponentsRequestEvent.FirewallComponent component : components) {
                if (quarantinedPaths.contains(component.getPath())) {
                    quarantinedVersions.add(component.getVersion());
                    continue;
                }
                allowedVersions.add(component.getVersion());
            }
            npmAllowedVersions.put((Object)packageId.id(), allowedVersions);
            return quarantinedVersions;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.log.error("Error getting quarantined versions for packageId '{}'", (Object)packageId.id(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isFirewallEnabled(Repository repository) {
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter capabilityReferenceFilter = CapabilityReferenceFilterBuilder.capabilities().withType(new CapabilityType(CLM_CAPABILITY_TYPE_ID)).withProperty(REPOSITORY_KEY, repository.getName()).enabled();
        Collection capabilityReferences = this.capabilityRegistry.get((com.google.common.base.Predicate)capabilityReferenceFilter);
        return !capabilityReferences.isEmpty();
    }

    private void maybeRewriteLatest(List<NpmFieldMatcher> excludeVersions, List<String> quarantinedVersions, List<String> allVersions) {
        if (excludeVersions.size() > 0) {
            excludeVersions.add(NpmFieldFactory.rewriteLatest(quarantinedVersions, allVersions));
        }
    }

    private boolean noneAreAllowed(List<String> versions, List<String> quarantinedVersions) {
        return versions.size() == quarantinedVersions.size();
    }

    private Predicate<String> quarantined(List<String> allowedVersions) {
        return version -> !allowedVersions.contains(version);
    }
}

