/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.npm.internal.NpmProxyFacet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;

@Named
@Facet.Exposed
public class NpmProxyCacheInvalidatorFacetImpl
extends FacetSupport {
    @Subscribe
    @AllowConcurrentEvents
    protected void on(RepositoryUpdatedEvent event) {
        Repository repository = event.getRepository();
        repository.optionalFacet(NpmProxyFacet.class).ifPresent(npm -> {
            if (!Objects.equals(NpmProxyCacheInvalidatorFacetImpl.getRemoteUrl(repository.getConfiguration()), NpmProxyCacheInvalidatorFacetImpl.getRemoteUrl(event.getOldConfiguration()))) {
                npm.invalidateProxyCaches();
            }
        });
    }

    private static Object getRemoteUrl(Configuration configuration) {
        return Optional.ofNullable((Map)configuration.getAttributes().get("proxy")).map(proxy -> {
            if (proxy instanceof Map) {
                return proxy.get("remoteUrl");
            }
            return null;
        }).orElse(null);
    }
}

