/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.matchers.ActionMatcher;
import org.sonatype.nexus.repository.view.matchers.LiteralMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.LogicMatchers;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public final class NpmPaths {
    public static final String NPM_V1_SECURITY_AUDITS = "/-/npm/v1/security/audits";
    public static final String T_TOKEN = "token";
    public static final String T_PACKAGE_NAME = "packageName";
    public static final String T_PACKAGE_VERSION = "packageVersion";
    public static final String T_PACKAGE_TAG = "packageTag";
    public static final String T_PACKAGE_SCOPE = "packageScope";
    public static final String T_REVISION = "revision";
    public static final String T_TARBALL_NAME = "tarballName";
    public static final String T_USERNAME = "userName";
    public static final String USER_LOGIN_PREFIX = "/-/user/org.couchdb.user:";

    public static Route.Builder searchIndexMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), LogicMatchers.or((Matcher[])new Matcher[]{new LiteralMatcher("/-/all"), new LiteralMatcher("/-/all/since")})}));
    }

    public static Route.Builder searchV1Matcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new LiteralMatcher("/-/v1/search")}));
    }

    public static Route.Builder whoamiMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new LiteralMatcher("/-/whoami")}));
    }

    public static Route.Builder pingMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new LiteralMatcher("/-/ping")}));
    }

    public static Route.Builder packageMatcher(String ... httpMethod) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(httpMethod), LogicMatchers.or((Matcher[])new Matcher[]{new TokenMatcher("/{packageName}"), new TokenMatcher("/@{packageScope}/{packageName}"), new TokenMatcher("/{packageName}/{packageVersion}")})}));
    }

    public static Route.Builder packageMatcherWithRevision(String httpMethod) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{httpMethod}), LogicMatchers.or((Matcher[])new Matcher[]{new TokenMatcher("/{packageName}/-rev/{revision}"), new TokenMatcher("/@{packageScope}/{packageName}/-rev/{revision}")})}));
    }

    public static Route.Builder tarballMatcher(String ... httpMethod) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(httpMethod), LogicMatchers.or((Matcher[])new Matcher[]{new TokenMatcher("/{packageName}/-/{tarballName}"), new TokenMatcher("/@{packageScope}/{packageName}/-/{tarballName}")})}));
    }

    public static Route.Builder distTagsMatcher(String httpMethod) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{httpMethod}), LogicMatchers.or((Matcher[])new Matcher[]{new TokenMatcher("/-/package/{packageName}/dist-tags"), new TokenMatcher("/-/package/@{packageScope}/{packageName}/dist-tags")})}));
    }

    public static Route.Builder distTagsUpdateMatcher(String httpMethod) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{httpMethod}), LogicMatchers.or((Matcher[])new Matcher[]{new TokenMatcher("/-/package/{packageName}/dist-tags/{packageTag}"), new TokenMatcher("/-/package/@{packageScope}/{packageName}/dist-tags/{packageTag}")})}));
    }

    public static Route.Builder tarballMatcherWithRevision(String httpMethod) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{httpMethod}), LogicMatchers.or((Matcher[])new Matcher[]{new TokenMatcher("/{packageName}/-/{tarballName}/-rev/{revision}"), new TokenMatcher("/@{packageScope}/{packageName}/-/{tarballName}/-rev/{revision}")})}));
    }

    public static Route.Builder userMatcher(String httpMethod) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{httpMethod}), new TokenMatcher("/-/user/org.couchdb.user:{userName}")}));
    }

    public static Route.Builder tokenMatcher(String httpMethod) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{httpMethod}), new TokenMatcher("/-/user/token/{token}")}));
    }

    public static Route.Builder auditMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"POST"}), new LiteralMatcher(NPM_V1_SECURITY_AUDITS)}));
    }

    public static Route.Builder auditQuickMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"POST"}), new LiteralMatcher("/-/npm/v1/security/audits/quick")}));
    }

    public static Route.Builder auditBulkMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"POST"}), new LiteralMatcher("/-/npm/v1/security/advisories/bulk")}));
    }

    @Nonnull
    public static NpmPackageId packageId(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        String packageName = (String)state.getTokens().get(T_PACKAGE_NAME);
        Preconditions.checkNotNull((Object)packageName);
        String version = (String)state.getTokens().get(T_PACKAGE_VERSION);
        if (!Strings2.isBlank((String)version)) {
            packageName = String.valueOf(packageName) + "-" + version;
        }
        String packageScope = (String)state.getTokens().get(T_PACKAGE_SCOPE);
        return new NpmPackageId(packageScope, packageName);
    }

    public static Optional<String> version(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        return Optional.ofNullable((String)state.getTokens().get(T_PACKAGE_VERSION));
    }

    @Nonnull
    public static String tarballName(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        String tarballName = (String)state.getTokens().get(T_TARBALL_NAME);
        Preconditions.checkNotNull((Object)tarballName);
        return tarballName;
    }

    @Nullable
    public static DateTime indexSince(Parameters parameters) {
        String tsStr;
        if (parameters != null && "update_after".equals(parameters.get("stale")) && !Strings2.isBlank((String)(tsStr = parameters.get("startkey")))) {
            try {
                return new DateTime(Long.parseLong(tsStr));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    @Nullable
    static String revision(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        return (String)state.getTokens().get(T_REVISION);
    }
}

