/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.json.NestedAttributesMapJsonParser;
import org.sonatype.nexus.repository.json.NestedAttributesMapUntypedObjectDeserializer;

public class NpmNestedAttributesMapUntypedObjectDeserializer
extends NestedAttributesMapUntypedObjectDeserializer {
    public NpmNestedAttributesMapUntypedObjectDeserializer(NestedAttributesMapJsonParser jsonParser) {
        super(jsonParser);
    }

    protected Object mapObject(JsonParser parser, DeserializationContext context) throws IOException {
        NestedAttributesMap childFromRoot;
        if (!this.isDefaultMapping() && Objects.nonNull(childFromRoot = this.getChildFromRoot())) {
            return this.isMappingField("versions") ? this.mapVersionsObject(parser, context, childFromRoot) : this.mapByOverlaying(parser, context, childFromRoot);
        }
        return super.mapObject(parser, context);
    }

    private Object mapByOverlaying(JsonParser parser, DeserializationContext context, NestedAttributesMap mapFromRoot) throws IOException {
        return NpmMetadataUtils.overlay(mapFromRoot.backing(), (Map)super.mapObject(parser, context), false);
    }

    private Object mapVersionsObject(JsonParser parser, DeserializationContext context, NestedAttributesMap mapFromRoot) throws IOException {
        Map recessiveChild = mapFromRoot.backing();
        Map<String, Object> dominantChild = this.mapVersionsObject(parser, context);
        for (Map.Entry<String, Object> dominantVersion : dominantChild.entrySet()) {
            recessiveChild.put(String.valueOf(dominantVersion.getKey()), dominantVersion.getValue());
        }
        return recessiveChild;
    }

    private Map<String, Object> mapVersionsObject(JsonParser parser, DeserializationContext context) throws IOException {
        try {
            this.enableDefaultMapping();
            Map map = (Map)super.mapObject(parser, context);
            return map;
        }
        finally {
            this.disableDefaultMapping();
        }
    }
}

