/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMergeObjectMapper;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;

public final class NpmMetadataUtils {
    public static final DateTimeFormatter NPM_TIMESTAMP_FORMAT = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);

    private NpmMetadataUtils() {
    }

    @Nonnull
    public static String extractTarballName(String tarballUrl) {
        int idx = tarballUrl.lastIndexOf(47);
        if (idx != -1) {
            return tarballUrl.substring(idx + 1);
        }
        return tarballUrl;
    }

    @Nullable
    public static String extractTarballName(NestedAttributesMap packageMetadata) {
        String version = (String)packageMetadata.child("dist-tags").get("latest", String.class);
        if (version == null) {
            return null;
        }
        String url = (String)packageMetadata.child("versions").child(version).child("dist").get("tarball", String.class);
        if (url == null) {
            return null;
        }
        return NpmMetadataUtils.extractTarballName(url);
    }

    @Nullable
    public static NestedAttributesMap selectVersionByTarballName(NestedAttributesMap packageRoot, String tarballName) {
        String extractedTarballName = NpmMetadataUtils.extractTarballName(tarballName);
        NestedAttributesMap versions = packageRoot.child("versions");
        for (String v : versions.keys()) {
            NestedAttributesMap version = versions.child(v);
            String versionTarballUrl = (String)version.child("dist").get("tarball", String.class);
            if (!extractedTarballName.equals(NpmMetadataUtils.extractTarballName(versionTarballUrl))) continue;
            return version;
        }
        return null;
    }

    public static DateTime maintainTime(NestedAttributesMap packageRoot) {
        NestedAttributesMap time = packageRoot.child("time");
        DateTime now = DateTime.now();
        String nowString = NPM_TIMESTAMP_FORMAT.print((ReadableInstant)now);
        if (!time.contains("created")) {
            time.set("created", (Object)nowString);
        }
        time.set("modified", (Object)nowString);
        for (String version : packageRoot.child("versions").keys()) {
            if (time.contains(version)) continue;
            time.set(version, (Object)nowString);
        }
        return now;
    }

    @Nullable
    public static DateTime lastModified(NestedAttributesMap packageRoot) {
        NestedAttributesMap time = packageRoot.child("time");
        String modified = (String)time.get("modified", String.class);
        if (modified != null) {
            return NPM_TIMESTAMP_FORMAT.parseDateTime(modified);
        }
        return null;
    }

    public static void rewriteTarballUrl(String repositoryName, NestedAttributesMap packageRoot) {
        if (BaseUrlHolder.isSet()) {
            NestedAttributesMap versions = packageRoot.child("versions");
            for (String v : versions.keys()) {
                if (!(versions.get(v) instanceof Map)) continue;
                NestedAttributesMap version = versions.child(v);
                NestedAttributesMap dist = version.child("dist");
                String tarballName = NpmMetadataUtils.extractTarballName((String)dist.get("tarball", String.class));
                dist.set("tarball", (Object)String.format("%s/repository/%s/%s/-/%s", BaseUrlHolder.get(), repositoryName, version.get("name"), tarballName));
            }
        }
    }

    static String rewriteTarballUrl(String repositoryName, String name, String currentTarballUrl) {
        if (BaseUrlHolder.isSet()) {
            return String.format("%s/repository/%s/%s/-/%s", BaseUrlHolder.get(), repositoryName, name, NpmMetadataUtils.extractTarballName(currentTarballUrl));
        }
        return currentTarballUrl;
    }

    public static String createRepositoryPath(String name, String version) {
        NpmPackageId packageId = NpmPackageId.parse(name);
        String tarballName = NpmMetadataUtils.createTarballName(packageId.name(), version);
        return String.format("%s/-/%s", packageId.id(), tarballName);
    }

    public static String createTarballName(String name, String version) {
        return String.format("%s-%s.tgz", name, version);
    }

    @Nonnull
    public static NestedAttributesMap shrink(NestedAttributesMap packageRoot) {
        NestedAttributesMap versions = packageRoot.child("versions");
        for (Map.Entry version : versions) {
            version.setValue(NpmMetadataUtils.resolveVersionToTag(packageRoot, (String)version.getKey()));
        }
        return packageRoot;
    }

    @Nonnull
    public static NestedAttributesMap overlay(NestedAttributesMap recessive, NestedAttributesMap dominant) {
        NpmMetadataUtils.overlay(recessive.backing(), dominant.backing(), true);
        return recessive;
    }

    @Nonnull
    public static NestedAttributesMap merge(String key, List<NestedAttributesMap> packages) {
        NestedAttributesMap result = new NestedAttributesMap(key, (Map)Maps.newHashMap());
        String latestVersion = null;
        for (NestedAttributesMap pkg : packages) {
            String pkgLatestVersion = (String)pkg.child("dist-tags").get("latest", String.class);
            if (pkgLatestVersion != null && (latestVersion == null || NpmVersionComparator.versionComparator.compare(pkgLatestVersion, latestVersion) > 0)) {
                latestVersion = pkgLatestVersion;
            }
            NpmMetadataUtils.overlay(result.backing(), pkg.backing(), false);
        }
        result.child("dist-tags").set("latest", latestVersion);
        result.remove("_id");
        result.remove("_rev");
        return result;
    }

    public static NestedAttributesMap mergeContents(List<Content> contents) throws IOException {
        ArrayList streams = Lists.newArrayList();
        for (Content content : contents) {
            streams.add(() -> ((Content)content).openInputStream());
        }
        return new NpmMergeObjectMapper().merge(streams);
    }

    public static NestedAttributesMap parseContent(Content content) throws IOException {
        return new NpmMergeObjectMapper().read(() -> ((Content)content).openInputStream());
    }

    public static Map<String, Object> overlay(Map<String, Object> recessive, Map<String, Object> dominant, boolean mergeVersionDocuments) {
        for (Map.Entry<String, Object> dominantEntry : dominant.entrySet()) {
            String key = dominantEntry.getKey();
            Object recessiveValue = recessive.get(key);
            Object dominantValue = dominantEntry.getValue();
            if (dominantValue instanceof Map && recessiveValue instanceof Map) {
                Map recessiveChild = (Map)recessiveValue;
                Map dominantChild = (Map)dominantValue;
                if (NpmMetadataUtils.isSpecialOverlayKey(key)) {
                    recessive.put(key, dominantValue);
                    continue;
                }
                if (mergeVersionDocuments || !"versions".equals(key) && !"dist-tags".equals(key)) {
                    recessive.put(key, NpmMetadataUtils.overlay(recessiveChild, dominantChild, mergeVersionDocuments));
                    continue;
                }
                for (Map.Entry dominantVersion : dominantChild.entrySet()) {
                    recessiveChild.put((String)dominantVersion.getKey(), dominantVersion.getValue());
                }
                continue;
            }
            if (dominantValue instanceof String && recessiveValue instanceof Map && "versions".equals(key)) continue;
            recessive.put(key, dominantValue);
        }
        return recessive;
    }

    private static boolean isSpecialOverlayKey(String key) {
        return "dependencies".equals(key) || "devDependencies".equals(key) || "scripts".equals(key) || "author".equals(key) || "publishConfig".equals(key);
    }

    private static String resolveVersionToTag(NestedAttributesMap packageRoot, String version) {
        NestedAttributesMap distTags = packageRoot.child("dist-tags");
        if (!distTags.isEmpty()) {
            for (Map.Entry distTag : distTags) {
                if (!version.equals(distTag.getValue())) continue;
                return (String)distTag.getKey();
            }
        }
        return version;
    }

    public static String getLatestVersionFromPackageRoot(NestedAttributesMap pkg) {
        return (String)pkg.child("dist-tags").get("latest", String.class);
    }

    public static NestedAttributesMap retrievePackageRoot(NpmPackageId packageId, Context context, Repository repository) throws IOException {
        try {
            Request getRequest = new Request.Builder().action("GET").path("/" + packageId.id()).build();
            Response response = ((ViewFacet)repository.facet(ViewFacet.class)).dispatch(getRequest, context);
            if (response.getPayload() == null) {
                throw new IOException("Could not retrieve package " + packageId);
            }
            Throwable throwable = null;
            Object var6_9 = null;
            try (Payload payload = response.getPayload();){
                return NpmJsonUtils.parse(() -> ((Payload)payload).openInputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IOException(e);
        }
    }

    public static List<String> findCachedVersionsRemovedFromRemote(NestedAttributesMap cachedRoot, NestedAttributesMap newPackageRoot, BiFunction<NpmPackageId, String, Boolean> componentExists) {
        ArrayList<String> cachedVersionsRemovedFromRemote = new ArrayList<String>();
        Set newVersions = newPackageRoot.child("versions").keys();
        NpmPackageId packageId = NpmPackageId.parse((String)Preconditions.checkNotNull((Object)newPackageRoot.get("name")));
        for (String version : cachedRoot.child("versions").keys()) {
            if (newVersions.contains(version) || !componentExists.apply(packageId, version).booleanValue()) continue;
            cachedVersionsRemovedFromRemote.add(version);
        }
        return cachedVersionsRemovedFromRemote;
    }

    public static NestedAttributesMap mergePackageRoots(NestedAttributesMap newPackageRoot, NestedAttributesMap existingPackageRoot, List<String> cachedVersions) {
        NestedAttributesMap mergedRoot = newPackageRoot;
        if (!cachedVersions.isEmpty()) {
            mergedRoot = NpmMetadataUtils.merge(existingPackageRoot.getKey(), (List<NestedAttributesMap>)ImmutableList.of((Object)existingPackageRoot, (Object)newPackageRoot));
            NpmMetadataUtils.removeVersionsNotCachedAndNotInNewRoot(mergedRoot, existingPackageRoot, cachedVersions);
        }
        return mergedRoot;
    }

    public static void removeVersionsNotCachedAndNotInNewRoot(NestedAttributesMap newPackageRoot, NestedAttributesMap existingPackageRoot, List<String> cachedVersions) {
        for (String version : newPackageRoot.child("versions").keys()) {
            if (cachedVersions.contains(version) || existingPackageRoot.child("versions").keys().contains(version)) continue;
            newPackageRoot.child("versions").remove(version);
        }
    }
}

