/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.google.common.collect.Maps;
import com.sonatype.nexus.repository.npm.internal.NpmNestedAttributesMapUntypedObjectDeserializer;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.json.MergeObjectMapper;
import org.sonatype.nexus.repository.json.NestedAttributesMapJsonParser;
import org.sonatype.nexus.repository.json.NestedAttributesMapStdValueInstantiator;
import org.sonatype.nexus.repository.json.SourceMapDeserializer;

public class NpmMergeObjectMapper
extends MergeObjectMapper {
    public NestedAttributesMap merge(List<InputStreamSupplier> inputStreams) throws IOException {
        return this.merge(inputStreams, null);
    }

    public NestedAttributesMap merge(List<InputStreamSupplier> inputStreams, @Nullable Charset charset) throws IOException {
        String latestVersion = null;
        NestedAttributesMap result = new NestedAttributesMap("mergeMap", (Map)Maps.newHashMap());
        for (InputStreamSupplier inputStreamSupplier : inputStreams) {
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream inputStream = inputStreamSupplier.get();){
                this.merge(result, inputStream, charset);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            latestVersion = this.updateLatestVersion(result, latestVersion);
        }
        result.child("dist-tags").set("latest", latestVersion);
        result.remove("_id");
        result.remove("_rev");
        return result;
    }

    protected void deserialize(NestedAttributesMapJsonParser parser, DeserializationContext context, MapDeserializer rootDeserializer) throws IOException {
        SourceMapDeserializer.of((JavaType)rootDeserializer.getValueType(), (ValueInstantiator)new NestedAttributesMapStdValueInstantiator(parser.getRoot()), (JsonDeserializer)new NpmNestedAttributesMapUntypedObjectDeserializer(parser)).deserialize((JsonParser)parser, context);
    }

    private String updateLatestVersion(NestedAttributesMap result, String latestVersion) {
        String pkgLatestVersion = (String)result.child("dist-tags").get("latest", String.class);
        if (Objects.nonNull(pkgLatestVersion) && (Objects.isNull(latestVersion) || NpmVersionComparator.versionComparator.compare(pkgLatestVersion, latestVersion) > 0)) {
            return pkgLatestVersion;
        }
        return latestVersion;
    }
}

