/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.InvalidContentException;

public final class NpmJsonUtils {
    public static final TypeReference<HashMap<String, Object>> rawMapJsonTypeRef = new TypeReference<HashMap<String, Object>>(){};
    static final TypeReference<List<Object>> rawListJsonTypeRef = new TypeReference<List<Object>>(){};
    public static final ObjectMapper mapper = new ObjectMapper();

    static {
        mapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
    }

    private NpmJsonUtils() {
    }

    @Nonnull
    public static NestedAttributesMap parse(InputStreamSupplier streamSupplier) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = streamSupplier.get();){
                Map backing = (Map)mapper.readValue(in, rawMapJsonTypeRef);
                NpmJsonUtils.removeVersionBuildMetadata(backing);
                return new NestedAttributesMap(String.valueOf(backing.get("name")), backing);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException e) {
            if (e.getMessage().contains("Invalid UTF-8")) {
                Map backing = (Map)mapper.readValue((Reader)new InputStreamReader(streamSupplier.get(), StandardCharsets.ISO_8859_1), rawMapJsonTypeRef);
                NpmJsonUtils.removeVersionBuildMetadata(backing);
                return new NestedAttributesMap(String.valueOf(backing.get("name")), backing);
            }
            throw new InvalidContentException("Invalid JSON input", (Throwable)e);
        }
    }

    public static void serialize(Writer out, NestedAttributesMap packageRoot) {
        try {
            mapper.writeValue(out, (Object)packageRoot.backing());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static byte[] bytes(NestedAttributesMap packageRoot) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
        NpmJsonUtils.serialize(writer, packageRoot);
        return byteArrayOutputStream.toByteArray();
    }

    @Nonnull
    static InputStreamSupplier supplier(byte[] content) throws IOException {
        return () -> new ByteArrayInputStream(content);
    }

    private static void removeVersionBuildMetadata(Map<String, Object> backing) {
        String version = String.valueOf(backing.get("version"));
        int metadataBegin = version.indexOf(43);
        if (metadataBegin > -1) {
            backing.put("version", version.substring(0, metadataBegin));
        }
    }
}

