/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.sonatype.nexus.repository.npm.internal.NpmResponses;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

@Named
@Singleton
public class NpmGroupWriteHandler
extends GroupHandler {
    @Inject
    @Named(value="groupWriteHandler")
    Provider<GroupHandler> groupWriteHandler;

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        if (this.groupWriteHandler.get() != null) {
            Response response = ((GroupHandler)this.groupWriteHandler.get()).handle(context);
            Status status = response.getStatus();
            if (status.isSuccessful()) {
                return response;
            }
            return NpmResponses.failureWithStatusPayload(status.getCode(), status.getMessage());
        }
        return NpmResponses.forbidden("Deploying to groups is a PRO-licensed feature. See https://links.sonatype.com/product-nexus-repository");
    }
}

