/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.sonatype.nexus.repository.npm.internal.NpmFieldDeserializer;
import com.sonatype.nexus.repository.npm.internal.NpmFieldMatcher;
import com.sonatype.nexus.repository.npm.internal.NpmFieldUnmatcher;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.sonatype.nexus.repository.Repository;

public class NpmFieldFactory {
    public static final NpmFieldDeserializer NULL_DESERIALIZER = new NpmFieldDeserializer(){

        @Override
        public Object deserialize(String fieldName, Object defaultValue, JsonParser parser, DeserializationContext context, JsonGenerator generator) {
            return null;
        }
    };
    public static final NpmFieldDeserializer SKIP_OBJECT_DESERIALIZER = new SkipObjectNpmFieldDeserializer();
    public static final NpmFieldMatcher REMOVE_ID_MATCHER = NpmFieldFactory.removeFieldMatcher("_id", "/_id");
    public static final NpmFieldMatcher REMOVE_REV_MATCHER = NpmFieldFactory.removeFieldMatcher("_rev", "/_rev");
    public static final List<NpmFieldMatcher> REMOVE_DEFAULT_FIELDS_MATCHERS = Arrays.asList(REMOVE_ID_MATCHER, REMOVE_REV_MATCHER);
    public static final String DIST_TAGS_LATEST = "/dist-tags/latest";
    public static final String LATEST = "latest";

    private NpmFieldFactory() {
    }

    public static NpmFieldMatcher removeFieldMatcher(String fieldName, String pathRegex) {
        return new NpmFieldMatcher(fieldName, pathRegex, NULL_DESERIALIZER);
    }

    public static NpmFieldMatcher removeObjectFieldMatcher(String fieldName, String pathRegex) {
        return new NpmFieldMatcher(fieldName, pathRegex, SKIP_OBJECT_DESERIALIZER);
    }

    public static NpmFieldUnmatcher missingFieldMatcher(String fieldName, String pathRegex, Supplier<Object> supplier) {
        return new NpmFieldUnmatcher(fieldName, pathRegex, NpmFieldFactory.missingFieldDeserializer(supplier));
    }

    public static NpmFieldDeserializer missingFieldDeserializer(final Supplier<Object> supplier) {
        NpmFieldDeserializer deserializer = new NpmFieldDeserializer(){

            @Override
            public Object deserializeValue(Object defaultValue) {
                return supplier.get();
            }
        };
        return deserializer;
    }

    public static NpmFieldUnmatcher missingRevFieldMatcher(Supplier<Object> supplier) {
        return NpmFieldFactory.missingFieldMatcher("_rev", "/_rev", supplier);
    }

    public static NpmFieldMatcher rewriteTarballUrlMatcher(Repository repository, String packageId) {
        return NpmFieldFactory.rewriteTarballUrlMatcher(repository.getName(), packageId);
    }

    public static NpmFieldMatcher rewriteTarballUrlMatcher(String repositoryName, String packageId) {
        return new NpmFieldMatcher("tarball", "/versions/(.*)/dist/tarball", NpmFieldFactory.rewriteTarballUrlDeserializer(repositoryName, packageId));
    }

    public static NpmFieldDeserializer rewriteTarballUrlDeserializer(final String repositoryName, final String packageId) {
        return new NpmFieldDeserializer(){

            @Override
            public Object deserializeValue(Object defaultValue) {
                return NpmMetadataUtils.rewriteTarballUrl(repositoryName, packageId, super.deserializeValue(defaultValue).toString());
            }
        };
    }

    public static NpmFieldMatcher rewriteLatest(List<String> nonCatalogedVersions, List<String> allVersions) {
        return new NpmFieldMatcher(LATEST, DIST_TAGS_LATEST, NpmFieldFactory.latestFieldDeserializer(nonCatalogedVersions, allVersions));
    }

    private static NpmFieldDeserializer latestFieldDeserializer(final List<String> nonCatalogedVersions, final List<String> allVersions) {
        return new NpmFieldDeserializer(){

            @Override
            public Object deserialize(String fieldName, Object defaultValue, JsonParser parser, DeserializationContext context, JsonGenerator generator) throws IOException {
                String overrideDefaultValue = (String)defaultValue;
                if (nonCatalogedVersions.contains(defaultValue)) {
                    int i = allVersions.size() - 1;
                    while (i >= 0) {
                        String next = (String)allVersions.get(i);
                        if (!nonCatalogedVersions.contains(next)) {
                            overrideDefaultValue = next;
                            break;
                        }
                        --i;
                    }
                }
                return super.deserialize(fieldName, overrideDefaultValue, parser, context, generator);
            }
        };
    }

    public static class SkipObjectNpmFieldDeserializer
    extends NpmFieldDeserializer {
        @Override
        public Object deserialize(String fieldName, Object defaultValue, JsonParser parser, DeserializationContext context, JsonGenerator generator) throws IOException {
            parser.skipChildren();
            return null;
        }
    }
}

