/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sonatype.nexus.repository.npm.internal.NpmAuditTarballFacet;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.audit.exceptions.PackageLockParsingException;
import com.sonatype.nexus.repository.npm.internal.audit.model.NpmAuditError;
import com.sonatype.nexus.repository.npm.internal.audit.parser.PackageLock;
import com.sonatype.nexus.repository.npm.internal.audit.parser.PackageLockParser;
import com.sonatype.nexus.repository.npm.internal.audit.report.ReportCreator;
import com.sonatype.nexus.repository.npm.internal.audit.report.ResponseReport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.cache.Cache;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.firewall.event.QuarantinedComponentVersions;
import org.sonatype.nexus.repository.firewall.event.QuarantinedComponentVersionsRequest;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.vulnerability.AuditComponent;
import org.sonatype.nexus.repository.vulnerability.AuditRepositoryComponent;
import org.sonatype.nexus.repository.vulnerability.ComponentValidation;
import org.sonatype.nexus.repository.vulnerability.ComponentValidationAvailable;
import org.sonatype.nexus.repository.vulnerability.ComponentsVulnerability;
import org.sonatype.nexus.repository.vulnerability.RepositoryComponentValidation;
import org.sonatype.nexus.repository.vulnerability.SeverityLevel;
import org.sonatype.nexus.repository.vulnerability.Vulnerability;
import org.sonatype.nexus.repository.vulnerability.VulnerabilityList;
import org.sonatype.nexus.repository.vulnerability.exceptions.ConfigurationException;
import org.sonatype.nexus.repository.vulnerability.exceptions.TarballLoadingException;

@Named
@Facet.Exposed
public class NpmAuditFacet
extends FacetSupport {
    private static final Logger logger = LoggerFactory.getLogger(NpmAuditFacet.class);
    public static final String QUICK_AUDIT_ATTR_NAME = "QUICK_AUDIT";
    public static final String APP_ID = "app_id";
    private static final String CACHE_NAME = "npm-audit-data";
    private final int timeout;
    private int statusTimeout;
    private final int cacheDuration;
    private final EventManager eventManager;
    private final ReportCreator reportCreator;
    private NpmAuditTarballFacet npmAuditTarballFacet;
    private final CacheHelper cacheHelper;
    private final CapabilityRegistry capabilityRegistry;
    private final Gson gson = new GsonBuilder().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    @Inject
    public NpmAuditFacet(@Named(value="${nexus.npm.audit.timeout:-600}") int timeout, @Named(value="${nexus.npm.audit.status_timeout:-20}") int statusTimeout, @Named(value="${nexus.npm.audit.cache_duration_hours:-12}") int cacheDuration, EventManager eventManager, ReportCreator reportCreator, CacheHelper cacheHelper, CapabilityRegistry capabilityRegistry) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"nexus.npm.audit.timeout must be greater than 0");
        this.timeout = timeout;
        Preconditions.checkArgument((statusTimeout > 0 ? 1 : 0) != 0, (Object)"nexus.npm.audit.status_timeout must be greater than 0");
        this.statusTimeout = statusTimeout;
        Preconditions.checkArgument((cacheDuration >= 0 ? 1 : 0) != 0, (Object)"nexus.npm.audit.cache_duration_hours must be greater than or equal to 0");
        this.cacheDuration = cacheDuration;
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.reportCreator = (ReportCreator)Preconditions.checkNotNull((Object)reportCreator);
        this.cacheHelper = (CacheHelper)Preconditions.checkNotNull((Object)cacheHelper);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.npmAuditTarballFacet = (NpmAuditTarballFacet)this.facet(NpmAuditTarballFacet.class);
        this.maybeCreateCache();
    }

    protected void doDelete() {
        this.maybeDestroyCache();
    }

    public Payload audit(Payload payload, Context context) throws ExecutionException, ConfigurationException, PackageLockParsingException, TarballLoadingException {
        String applicationId;
        if (payload == null) {
            throw new ConfigurationException(NpmAuditError.ABSENT_PARSING_FILE.getMessage());
        }
        this.checkIqServerAvailable();
        PackageLock packageLock = NpmAuditFacet.parseRequest(payload);
        String applicationIdFromHeader = this.maybeGetAppIdFromHeader(context);
        String applicationIdFromJson = packageLock.getRoot().getApplicationId();
        String string = applicationId = applicationIdFromHeader != null ? applicationIdFromHeader : applicationIdFromJson;
        if (this.log.isDebugEnabled()) {
            this.log.debug("appId from HTTP Header: {}", (Object)(applicationIdFromHeader != null ? applicationIdFromHeader : "N/A"));
            this.log.debug("appId from package-lock.json: {}", (Object)(applicationIdFromJson != null ? applicationIdFromJson : "N/A"));
            if (applicationId != null) {
                this.log.debug("Will use appId: {}", (Object)applicationId);
            }
        }
        ComponentsVulnerability componentsVulnerability = this.analyzeComponents(context, packageLock.getComponents(applicationId), applicationId);
        QuarantinedComponentVersions quarantinedComponentVersions = this.analyzeQuarantinedComponents(context.getRepository(), packageLock.getComponents(applicationId));
        return this.buildResponse(packageLock, componentsVulnerability, applicationId, quarantinedComponentVersions);
    }

    private void checkIqServerAvailable() throws ExecutionException {
        ComponentValidationAvailable validationAvailable = new ComponentValidationAvailable();
        this.eventManager.post((Object)validationAvailable);
        try {
            validationAvailable.getResult().get(this.statusTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private static PackageLock parseRequest(Payload payload) throws PackageLockParsingException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (GZIPInputStream stream = new GZIPInputStream(payload.openInputStream(), (int)payload.getSize());){
                return PackageLockParser.parse(IOUtils.toString((InputStream)stream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new PackageLockParsingException();
        }
    }

    private ComponentsVulnerability analyzeComponents(Context originalContext, Set<AuditComponent> componentsToAnalyze, String applicationId) throws ExecutionException, TarballLoadingException {
        Cache<AuditComponent, VulnerabilityList> cache = this.maybeCreateCache();
        ComponentsVulnerability componentsVulnerability = new ComponentsVulnerability();
        if (!componentsToAnalyze.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Handle {} npm components to analyze", (Object)componentsToAnalyze.size());
                this.log.trace("Evaluating components: {}", componentsToAnalyze);
            }
            if (cache != null) {
                for (AuditComponent auditComponent2 : componentsToAnalyze) {
                    VulnerabilityList componentVulnerability = (VulnerabilityList)cache.get((Object)auditComponent2);
                    if (componentVulnerability == null) continue;
                    List vulnerabilities = componentVulnerability.getVulnerabilities();
                    componentsVulnerability.addVulnerabilities(auditComponent2, vulnerabilities);
                }
            }
            Set foundAuditComponents = componentsVulnerability.getAuditComponents().keySet();
            Set<AuditComponent> auditComponents = componentsToAnalyze.stream().filter(c -> !foundAuditComponents.contains(c)).collect(Collectors.toSet());
            if (!auditComponents.isEmpty()) {
                try {
                    ComponentsVulnerability vulnerabilities = applicationId != null ? this.getComponentsVulnerabilityFromRemoteServer(auditComponents, applicationId) : this.getComponentsVulnerabilityFromRemoteServer(originalContext, auditComponents);
                    componentsVulnerability.addComponentsVulnerabilities(vulnerabilities);
                    if (cache != null) {
                        vulnerabilities.getAuditComponents().forEach((auditComponent, componentVulnerabilities) -> cache.put(auditComponent, (Object)new VulnerabilityList(componentVulnerabilities)));
                        Set componentsWithVulnerabilities = componentsVulnerability.getAuditComponents().keySet();
                        componentsToAnalyze.stream().filter(c -> !componentsWithVulnerabilities.contains(c)).forEach(component -> cache.put(component, (Object)new VulnerabilityList()));
                    }
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return componentsVulnerability;
    }

    private ComponentsVulnerability getComponentsVulnerabilityFromRemoteServer(Context originalContext, Set<AuditComponent> componentsToAnalyze) throws InterruptedException, ExecutionException, TimeoutException, TarballLoadingException {
        Set<AuditRepositoryComponent> repositoryComponents = this.getAuditRepositoryComponents(originalContext, componentsToAnalyze);
        Set validComponentsToScan = repositoryComponents.stream().filter(component -> component.getHash() != null).collect(Collectors.toSet());
        RepositoryComponentValidation componentValidation = new RepositoryComponentValidation(this.getRepository().getName(), validComponentsToScan);
        this.eventManager.post((Object)componentValidation);
        ComponentsVulnerability vulnerabilityResult = this.getVulnerabilityResult(componentValidation.getVulnerabilityResult());
        this.updateWithInvalidComponents(componentsToAnalyze, repositoryComponents, vulnerabilityResult);
        return vulnerabilityResult;
    }

    private void updateWithInvalidComponents(Set<AuditComponent> componentsToAnalyze, Set<AuditRepositoryComponent> repositoryComponents, ComponentsVulnerability vulnerabilityResult) {
        Map componentByRepoPath = componentsToAnalyze.stream().collect(Collectors.toMap(component -> NpmMetadataUtils.createRepositoryPath(component.getName(), component.getVersion()), UnaryOperator.identity()));
        Set componentsNotScanned = repositoryComponents.stream().filter(component -> component.getHash() == null).map(component -> (AuditComponent)componentByRepoPath.get(component.getPathname())).collect(Collectors.toSet());
        for (AuditComponent auditComponent : componentsNotScanned) {
            vulnerabilityResult.addVulnerability(auditComponent, new Vulnerability(SeverityLevel.LOW, "Component not found", null, "This component can not be audited because it is not stored in the repository being scanned"));
        }
    }

    private ComponentsVulnerability getComponentsVulnerabilityFromRemoteServer(Set<AuditComponent> componentsToAnalyze, String applicationId) throws InterruptedException, ExecutionException, TimeoutException {
        ComponentValidation componentValidation = new ComponentValidation(componentsToAnalyze, applicationId);
        this.eventManager.post((Object)componentValidation);
        return this.getVulnerabilityResult(componentValidation.getVulnerabilityResult());
    }

    private Set<AuditRepositoryComponent> getAuditRepositoryComponents(Context originalContext, Set<AuditComponent> componentsToAnalyze) throws TarballLoadingException {
        Stopwatch sw = Stopwatch.createStarted();
        Set<AuditRepositoryComponent> repositoryComponents = this.npmAuditTarballFacet.download(originalContext, componentsToAnalyze);
        long failedToDownloadCount = repositoryComponents.stream().filter(c -> c.getHash() == null).count();
        this.log.debug("Downloaded {} npm packages and failed to download {} npm packages in {}", new Object[]{(long)repositoryComponents.size() - failedToDownloadCount, failedToDownloadCount, sw.stop()});
        return repositoryComponents;
    }

    private ComponentsVulnerability getVulnerabilityResult(CompletableFuture<ComponentsVulnerability> future) throws InterruptedException, ExecutionException, TimeoutException {
        ComponentsVulnerability componentsVulnerability = future.get(this.timeout, TimeUnit.SECONDS);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Report: {}", (Object)this.gson.toJson((Object)componentsVulnerability.getAuditComponents()));
        }
        return componentsVulnerability;
    }

    private StringPayload buildResponse(PackageLock packageLock, ComponentsVulnerability componentsVulnerability, String applicationId, QuarantinedComponentVersions quarantinedComponentVersions) {
        ResponseReport responseReport = this.reportCreator.buildResponseReport(componentsVulnerability, packageLock, applicationId, quarantinedComponentVersions);
        String responseReportString = this.gson.toJson((Object)responseReport);
        this.log.trace("npm audit report: {}", (Object)responseReportString);
        this.log.debug("Build report with metadata: {}", (Object)responseReport.getMetadata());
        return new StringPayload(responseReportString, "application/json");
    }

    private Cache<AuditComponent, VulnerabilityList> maybeCreateCache() {
        if (this.cacheDuration > 0) {
            this.log.debug("Creating {} for: {}", (Object)this.getCacheName(), (Object)this.getRepository());
            Duration duration = new Duration(TimeUnit.HOURS, (long)this.cacheDuration);
            return this.cacheHelper.maybeCreateCache(this.getCacheName(), AuditComponent.class, VulnerabilityList.class, CreatedExpiryPolicy.factoryOf((Duration)duration));
        }
        return null;
    }

    private void maybeDestroyCache() {
        this.log.debug("Destroying {} for: {}", (Object)this.getCacheName(), (Object)this.getRepository());
        this.cacheHelper.maybeDestroyCache(this.getCacheName());
    }

    private String getCacheName() {
        return String.valueOf(this.getRepository().getName()) + CACHE_NAME;
    }

    @Nullable
    public String maybeGetAppIdFromHeader(Context context) {
        return context.getRequest().getHeaders().entries().stream().filter(entry -> ((String)entry.getValue()).matches("app_id:.*")).map(this.getAppIdValue()).findFirst().orElse(null);
    }

    private Function<Map.Entry<String, String>, String> getAppIdValue() {
        return entry -> {
            String[] split = ((String)entry.getValue()).split(":");
            if (split.length == 2) {
                return split[1].trim();
            }
            return null;
        };
    }

    public void clearCache() {
        this.maybeDestroyCache();
        this.maybeCreateCache();
    }

    private QuarantinedComponentVersions analyzeQuarantinedComponents(Repository repository, Set<AuditComponent> componentsToAnalyze) throws ExecutionException {
        QuarantinedComponentVersions quarantinedComponentVersions = new QuarantinedComponentVersions();
        Boolean removeQuarantinedVersions = (Boolean)repository.getConfiguration().attributes("npm").get("removeQuarantinedVersions", Boolean.class);
        if (!Boolean.TRUE.equals(removeQuarantinedVersions) || !this.isFirewallEnabled(repository)) {
            return quarantinedComponentVersions;
        }
        if (!componentsToAnalyze.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Handle {} npm components to analyze quarantined components", (Object)componentsToAnalyze.size());
                this.log.trace("Getting quarantine component versions for components: {}", componentsToAnalyze);
            }
            try {
                quarantinedComponentVersions = this.getQuarantinedComponentVersionsFromRemoteServer(componentsToAnalyze);
            }
            catch (InterruptedException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
        return quarantinedComponentVersions;
    }

    private boolean isFirewallEnabled(Repository repository) {
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter capabilityReferenceFilter = CapabilityReferenceFilterBuilder.capabilities().withType(new CapabilityType("firewall.audit")).withProperty("repository", repository.getName()).enabled();
        Collection capabilityReferences = this.capabilityRegistry.get((Predicate)capabilityReferenceFilter);
        return !capabilityReferences.isEmpty();
    }

    private QuarantinedComponentVersions getQuarantinedComponentVersionsFromRemoteServer(Set<AuditComponent> componentsToAnalyze) throws InterruptedException, ExecutionException, TimeoutException {
        Set repositoryComponents = componentsToAnalyze.stream().map(auditComponent -> new AuditRepositoryComponent("npm", NpmMetadataUtils.createRepositoryPath(auditComponent.getName(), auditComponent.getVersion()), null)).collect(Collectors.toSet());
        QuarantinedComponentVersionsRequest componentValidation = new QuarantinedComponentVersionsRequest(this.getRepository().getName(), repositoryComponents);
        this.eventManager.post((Object)componentValidation);
        QuarantinedComponentVersions quarantinedResult = this.getQuarantinedComponentVersionsResult(componentValidation.getQuarantinedResult());
        return quarantinedResult;
    }

    private QuarantinedComponentVersions getQuarantinedComponentVersionsResult(CompletableFuture<QuarantinedComponentVersions> future) throws InterruptedException, ExecutionException, TimeoutException {
        QuarantinedComponentVersions quarantinedComponentVersions = future.get(this.timeout, TimeUnit.SECONDS);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Report: {}", (Object)this.gson.toJson((Object)quarantinedComponentVersions.getAuditRepositoryComponents()));
        }
        return quarantinedComponentVersions;
    }
}

