/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.sonatype.nexus.repository.npm.internal.NpmResponses;
import com.sonatype.nexus.repository.npm.internal.audit.exceptions.PackageLockParsingException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.vulnerability.exceptions.AppIdMismatchException;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.ConfigurationException;
import org.sonatype.nexus.repository.vulnerability.exceptions.IQServerException;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;
import org.sonatype.nexus.repository.vulnerability.exceptions.TarballLoadingException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

@Named
@Singleton
public class NpmAuditErrorHandler
implements Handler {
    private static final Logger log = LoggerFactory.getLogger(NpmAuditErrorHandler.class);
    private static final String USER_ERROR_MSG = "Error fetching npm audit data. " + System.lineSeparator() + "See nexus.log for more details or contact your Nexus Repository Manager administrator.";
    private static final String USER_IQ_ERROR_MSG = "Error fetching data from IQ Server. " + System.lineSeparator() + "From the IQ server: ";

    @Nonnull
    public Response handle(@Nonnull Context context) {
        try {
            return context.proceed();
        }
        catch (PackageLockParsingException e) {
            return NpmResponses.npmErrorAuditResponse(400, e.getMessage());
        }
        catch (TarballLoadingException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return NpmResponses.npmErrorAuditResponse(404, USER_ERROR_MSG);
        }
        catch (ExecutionException e) {
            boolean quickAudit = (Boolean)context.getAttributes().require("QUICK_AUDIT");
            return this.handleAuditExceptions(e, quickAudit);
        }
        catch (TimeoutException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return NpmResponses.npmErrorAuditResponse(500, USER_ERROR_MSG);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return NpmResponses.npmErrorAuditResponse(500, USER_ERROR_MSG);
        }
    }

    private Response handleAuditExceptions(ExecutionException e, boolean quickAudit) {
        Throwable cause = e.getCause();
        if (cause instanceof CompatibilityException) {
            log.warn(cause.getMessage(), (Throwable)(log.isDebugEnabled() ? e : null));
            return NpmResponses.npmErrorAuditResponse(400, cause.getMessage());
        }
        if (cause instanceof VulnerabilityFetchingException || cause instanceof InternalException) {
            log.warn(cause.getMessage(), (Throwable)e);
            return NpmResponses.npmErrorAuditResponse(500, USER_ERROR_MSG);
        }
        if (cause instanceof ConfigurationException) {
            if (quickAudit) {
                log.debug(cause.getMessage(), (Throwable)e);
            } else {
                log.warn(cause.getMessage(), (Throwable)(log.isDebugEnabled() ? e : null));
            }
            return NpmResponses.npmErrorAuditResponse(400, cause.getMessage());
        }
        if (cause instanceof AppIdMismatchException) {
            return NpmResponses.npmErrorAuditResponse(400, cause.getMessage());
        }
        if (cause instanceof IQServerException) {
            log.warn(cause.getMessage(), (Throwable)e);
            return NpmResponses.npmErrorAuditResponse(500, String.valueOf(USER_IQ_ERROR_MSG) + cause.getMessage());
        }
        log.error(e.getMessage(), (Throwable)e);
        return NpmResponses.npmErrorAuditResponse(500, USER_ERROR_MSG);
    }
}

