/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm.internal;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MetadataVersionParser {
    public static final String VERSIONS = "versions";

    public static List<String> readVersions(InputStream is) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(is));){
            return MetadataVersionParser.extractVersions(jsonReader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static List<String> extractVersions(JsonReader reader) throws IOException {
        reader.beginObject();
        List<String> versions = new ArrayList<String>();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (VERSIONS.equals(name)) {
                versions = MetadataVersionParser.readVersions(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return versions;
    }

    private static List<String> readVersions(JsonReader reader) throws IOException {
        ArrayList<String> versions = new ArrayList<String>();
        JsonToken peek = reader.peek();
        if (peek.equals((Object)JsonToken.NULL)) {
            reader.skipValue();
            return versions;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            versions.add(name);
            reader.skipValue();
        }
        reader.endObject();
        return versions;
    }

    public static Map<String, String> readVersionHashes(InputStream is) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(is));){
            return MetadataVersionParser.extractVersionHashes(jsonReader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Map<String, String> extractVersionHashes(JsonReader reader) throws IOException {
        reader.beginObject();
        Map<String, String> versionHashes = Collections.emptyMap();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (VERSIONS.equals(name)) {
                versionHashes = MetadataVersionParser.readVersionHashes(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return versionHashes;
    }

    private static Map<String, String> readVersionHashes(JsonReader reader) throws IOException {
        LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
        JsonToken peek = reader.peek();
        if (peek.equals((Object)JsonToken.NULL)) {
            reader.skipValue();
            return versions;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String version = reader.nextName();
            String sha1 = MetadataVersionParser.processVersion(reader);
            versions.put(version, sha1);
        }
        reader.endObject();
        peek = reader.peek();
        if (peek != null) {
            return versions;
        }
        return versions;
    }

    private static String processVersion(JsonReader reader) throws IOException {
        String sha1 = null;
        reader.beginObject();
        if (MetadataVersionParser.findNode(reader, "dist")) {
            reader.beginObject();
            MetadataVersionParser.findNode(reader, "shasum");
            sha1 = reader.nextString();
            MetadataVersionParser.readRemainingKeys(reader);
            reader.endObject();
        }
        MetadataVersionParser.readRemainingKeys(reader);
        reader.endObject();
        return sha1;
    }

    private static void readRemainingKeys(JsonReader reader) throws IOException {
        while (reader.hasNext()) {
            reader.skipValue();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean findNode(JsonReader reader, String keyToFind) throws IOException {
        if (!reader.peek().equals((Object)JsonToken.NULL)) ** GOTO lbl7
        reader.skipValue();
        return false;
lbl-1000:
        // 1 sources

        {
            if (keyToFind.equals(reader.nextName())) {
                return true;
            }
            reader.skipValue();
lbl7:
            // 2 sources

            ** while (reader.hasNext())
        }
lbl8:
        // 1 sources

        return false;
    }
}

