/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import java.io.IOException;
import java.util.Map;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.upload.UploadHandler;
import org.sonatype.nexus.repository.view.Content;

public interface NpmUploadHandler
extends UploadHandler {
    default public Map<String, Object> ensureNpmPermitted(Repository repository, Map<String, Object> packageJson) {
        String name = (String)packageJson.get("name");
        String version = (String)packageJson.get("version");
        String repositoryPath = NpmMetadataUtils.createRepositoryPath(name, version);
        Map<String, String> coordinates = this.toCoordinates(packageJson);
        this.ensurePermitted(repository.getName(), "npm", repositoryPath, coordinates);
        return packageJson;
    }

    default public Map<String, String> toCoordinates(Map<String, Object> packageJson) {
        NpmPackageId packageId = NpmPackageId.parse((String)Preconditions.checkNotNull((Object)packageJson.get("name")));
        String version = (String)Preconditions.checkNotNull((Object)packageJson.get("version"));
        if (packageId.scope() != null) {
            return ImmutableMap.of((Object)"packageScope", (Object)packageId.scope(), (Object)"packageName", (Object)packageId.name(), (Object)"version", (Object)version);
        }
        return ImmutableMap.of((Object)"packageName", (Object)packageId.name(), (Object)"version", (Object)version);
    }

    public Content doPut(ImportFileConfiguration var1) throws IOException;
}

