/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.npm;

import com.sonatype.nexus.repository.npm.internal.NpmFormatAttributesExtractor;
import com.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;

@Named
@Singleton
public class NpmAttributeUtil {
    public static final String NAME = "name";
    public static final String DIST_TAGS = "dist-tags";
    public static final String VERSIONS = "versions";
    public static final String VERSION = "version";
    public static final String DEPRECATED = "deprecated";
    public static final String TIME = "time";
    public static final String MODIFIED = "modified";
    public static final String CREATED = "created";
    public static final String LATEST = "latest";
    public static final String DIST = "dist";
    public static final String TARBALL = "tarball";
    public static final String META_ID = "_id";
    public static final String META_REV = "_rev";
    public static final String META_UPDATED = "_updated";
    public static final String AUTHOR = "author";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "devDependencies";
    public static final String PUBLISH_CONFIG = "publishConfig";
    public static final String SCRIPTS = "scripts";
    public static final String EMAIL = "email";
    public static final String URL = "url";
    public static final String TYPE = "type";
    public static final String REPOSITORY = "repository";
    public static final String BUGS = "bugs";
    public static final String FIRST_STABLE_VERSION = "1.0.0";
    public static final String UNSTABLE = "unstable";

    public Map<String, Object> extractFormatAttributes(NestedAttributesMap data, String version) {
        HashMap<String, Object> npmAttributes = new HashMap<String, Object>();
        NestedAttributesMap attributes = data.child(VERSIONS).child(version);
        npmAttributes.put("scope", this.getScope(attributes.get(NAME)));
        npmAttributes.put(NAME, attributes.get(NAME));
        npmAttributes.put(VERSION, version);
        npmAttributes.put(AUTHOR, this.extractPersonInfo(attributes.get(AUTHOR)));
        npmAttributes.put("contributors", this.getContributors(attributes.get("contributors")));
        npmAttributes.put("description", attributes.get("description"));
        npmAttributes.put("license", this.getLicense(attributes.get("license")));
        npmAttributes.put("keywords", NpmFormatAttributesExtractor.extractStringCollection(attributes.get("keywords")));
        npmAttributes.put("os", NpmFormatAttributesExtractor.extractStringCollection(attributes.get("os")));
        npmAttributes.put("cpu", NpmFormatAttributesExtractor.extractStringCollection(attributes.get("cpu")));
        npmAttributes.put("engines", this.getEngines(attributes.get("engines")));
        npmAttributes.put("repository_url", this.extractStringFromMap(attributes.get(REPOSITORY), URL));
        npmAttributes.put("repository_type", this.extractStringFromMap(attributes.get(REPOSITORY), TYPE));
        npmAttributes.put("bugs_url", this.getBugsUrl(attributes.get(BUGS)));
        npmAttributes.put("bugs_email", this.extractStringFromMap(attributes.get(BUGS), EMAIL));
        npmAttributes.put("homepage", attributes.get("homepage"));
        boolean unstable = this.isUnstable(attributes.get(VERSION));
        npmAttributes.put("tagged_is", unstable ? UNSTABLE : "");
        npmAttributes.put("tagged_not", unstable ? "" : UNSTABLE);
        npmAttributes.put("search_normalized_version", NpmFormatAttributesExtractor.getSearchNormalizedVersion(attributes.get(VERSION)));
        return npmAttributes;
    }

    @Nullable
    private String extractPersonInfo(Object person) {
        if (person instanceof Map) {
            Map authorMap = (Map)person;
            ArrayList<String> pieces = new ArrayList<String>();
            if (authorMap.containsKey(NAME)) {
                pieces.add(String.valueOf(authorMap.get(NAME)));
            }
            if (authorMap.containsKey(EMAIL)) {
                pieces.add(String.format("<%s>", authorMap.get(EMAIL)));
            }
            if (authorMap.containsKey(URL)) {
                pieces.add(String.format("(%s)", authorMap.get(URL)));
            }
            return String.join((CharSequence)" ", pieces);
        }
        if (person instanceof String) {
            return person.toString();
        }
        return null;
    }

    @Nullable
    private String getScope(Object nameObject) {
        String name;
        if (nameObject instanceof String && (name = (String)nameObject).startsWith("@") && name.contains("/")) {
            return name.substring(1, name.indexOf(47));
        }
        return null;
    }

    @Nullable
    private List<String> getContributors(Object contributors) {
        if (contributors instanceof List) {
            return ((List)contributors).stream().map(this::extractPersonInfo).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (contributors instanceof Map || contributors instanceof String) {
            return Collections.singletonList(this.extractPersonInfo(contributors));
        }
        return null;
    }

    @Nullable
    private String getLicense(Object license) {
        if (license instanceof Map) {
            Map licenseMap = (Map)license;
            if (licenseMap.containsKey(TYPE)) {
                return licenseMap.get(TYPE).toString();
            }
            return null;
        }
        if (license instanceof String) {
            return license.toString();
        }
        return null;
    }

    @Nullable
    private Map<String, String> getEngines(Object engines) {
        if (engines instanceof Map) {
            Map enginesMap = (Map)engines;
            return enginesMap.entrySet().stream().collect(Collectors.toMap(entry -> Objects.toString(entry.getKey()), entry -> Objects.toString(entry.getValue())));
        }
        return null;
    }

    @Nullable
    private String getBugsUrl(Object bugs) {
        if (bugs instanceof String) {
            return (String)bugs;
        }
        return this.extractStringFromMap(bugs, URL);
    }

    @Nullable
    private String extractStringFromMap(Object possibleMap, String fieldKey) {
        Map map;
        if (possibleMap instanceof Map && (map = (Map)possibleMap).containsKey(fieldKey)) {
            Object value = map.get(fieldKey);
            if (value != null) {
                return value.toString();
            }
            return null;
        }
        return null;
    }

    private boolean isUnstable(Object versionObject) {
        if (versionObject != null) {
            String versionString = (String)versionObject;
            return NpmVersionComparator.versionComparator.compare(versionString, FIRST_STABLE_VERSION) < 0;
        }
        return true;
    }
}

