/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal.search.legacy;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Strings;
import com.sonatype.nexus.repository.content.npm.NpmContentFacet;
import com.sonatype.nexus.repository.content.npm.internal.NpmFacetSupport;
import com.sonatype.nexus.repository.content.npm.internal.search.legacy.NpmSearchIndexFacetCaching;
import com.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import com.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import com.sonatype.nexus.repository.npm.internal.NpmPackageId;
import com.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

@Deprecated
@Named
public class NpmSearchIndexFacetHosted
extends NpmSearchIndexFacetCaching {
    @Inject
    public NpmSearchIndexFacetHosted(EventManager eventManager, NpmPackageParser npmPackageParser) {
        super(eventManager, npmPackageParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nonnull
    protected Content buildIndex(Path path) throws IOException {
        NpmContentFacet content = (NpmContentFacet)this.getRepository().facet(NpmContentFacet.class);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
                try {
                    try (JsonGenerator generator = NpmJsonUtils.mapper.getFactory().createGenerator((Writer)writer);){
                        DateTime updated = new DateTime();
                        generator.writeStartObject();
                        generator.writeNumberField("_updated", updated.getMillis());
                        Continuation components = content.components().browse(1000, null);
                        while (!components.isEmpty()) {
                            components.forEach(component -> {
                                NpmPackageId packageId = Strings.isNullOrEmpty((String)component.namespace()) ? new NpmPackageId(null, component.name()) : new NpmPackageId(component.namespace(), component.name());
                                Optional<NestedAttributesMap> packageRoot = this.loadAndShrink(packageId);
                                if (packageRoot.isPresent()) {
                                    try {
                                        generator.writeObjectField(packageId.id(), (Object)packageRoot.get().backing());
                                    }
                                    catch (IOException e) {
                                        throw new UncheckedIOException(e);
                                    }
                                }
                            });
                            components = content.components().browse(1000, components.nextContinuationToken());
                        }
                        generator.writeEndObject();
                        generator.flush();
                    }
                    if (writer == null) return new Content((Payload)new StreamPayload(() -> new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), Files.size(path), "application/json"));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (writer == null) throw throwable;
                    ((Writer)writer).close();
                    throw throwable;
                }
                ((Writer)writer).close();
                return new Content((Payload)new StreamPayload(() -> new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), Files.size(path), "application/json"));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private Optional<NestedAttributesMap> loadAndShrink(NpmPackageId packageId) {
        try {
            return NpmFacetSupport.loadPackageRoot(packageId, this.content()).map(NpmSearchIndexFacetHosted::shrink);
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }

    private static NestedAttributesMap shrink(NestedAttributesMap packageRoot) {
        if (!packageRoot.isEmpty()) {
            return NpmMetadataUtils.shrink(packageRoot);
        }
        return packageRoot;
    }
}

