/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.content.AttributeChangeSet;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.replication.ReplicationUtils;

@Named
public class NpmReplicationIngestionService
extends ComponentSupport {
    public FluentComponent saveTarballComponent(FluentComponents fluentComponents, @Nullable Map<String, Object> componentAttributes, String componentName, String componentVersion, String componentScope) {
        FluentComponentBuilder componentBuilder = fluentComponents.name(componentName).version(componentVersion).namespace(componentScope);
        if (componentAttributes != null) {
            for (Map.Entry<String, Object> attr : componentAttributes.entrySet()) {
                componentBuilder.attributes(attr.getKey(), attr.getValue());
            }
        }
        return componentBuilder.getOrCreate();
    }

    public void saveTarballAsset(FluentAssets fluentAssets, FluentComponent component, String path, Blob blob, Map<String, Object> assetAttributes) {
        FluentAsset fluentAsset = fluentAssets.path(path).component((Component)component).kind(NpmAttributes.AssetKind.TARBALL.toString()).blob(blob, ReplicationUtils.getChecksumsFromProperties(assetAttributes)).save();
        AttributeChangeSet changeSet = new AttributeChangeSet();
        for (Map.Entry<String, Object> entry : assetAttributes.entrySet()) {
            changeSet.attributes(AttributeOperation.SET, entry.getKey(), entry.getValue());
        }
        fluentAsset.attributes(changeSet);
    }

    public void savePackageRootAsset(FluentAssets fluentAssets, String path, Blob blob, Map<String, Object> assetAttributes) {
        FluentAsset fluentAsset = fluentAssets.path(path).kind(NpmAttributes.AssetKind.PACKAGE_ROOT.toString()).blob(blob, ReplicationUtils.getChecksumsFromProperties(assetAttributes)).save();
        AttributeChangeSet changeSet = new AttributeChangeSet();
        for (Map.Entry<String, Object> entry : assetAttributes.entrySet()) {
            changeSet.attributes(AttributeOperation.SET, entry.getKey(), entry.getValue());
        }
        fluentAsset.attributes(changeSet);
    }
}

