/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.content.npm.internal;

import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import com.sonatype.nexus.repository.npm.internal.NpmAttributes;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.replication.ReplicationFacetSupport;
import org.sonatype.nexus.repository.content.replication.ReplicationIngestionService;

@Named(value="npm")
public class NpmReplicationFacet
extends ReplicationFacetSupport {
    private final ReplicationIngestionService ingestionService;

    @Inject
    public NpmReplicationFacet(ReplicationIngestionService ingestionService) {
        this.ingestionService = Objects.requireNonNull(ingestionService);
    }

    public void doReplicate(String path, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes) {
        ContentFacet contentFacet = (ContentFacet)this.facet(ContentFacet.class);
        FluentAssets fluentAssets = contentFacet.assets();
        FluentComponents fluentComponents = contentFacet.components();
        if (path.endsWith(".tgz")) {
            String fullName = NpmCoordinateUtil.extractFullName(path);
            String componentName = NpmCoordinateUtil.extractName(fullName);
            String componentScope = NpmCoordinateUtil.extractScope(fullName);
            String componentVersion = NpmCoordinateUtil.extractVersion(path);
            FluentComponent component = this.ingestionService.replicateComponent(fluentComponents, componentAttributes, componentName, componentVersion, componentScope);
            this.maybeSaveComponentAttributes(component, componentAttributes);
            this.ingestionService.replicateAsset(fluentAssets, path, blob, assetAttributes, NpmAttributes.AssetKind.TARBALL.toString(), component);
        } else {
            this.ingestionService.replicateAsset(fluentAssets, path, blob, assetAttributes, NpmAttributes.AssetKind.PACKAGE_ROOT.toString());
        }
    }

    private void maybeSaveComponentAttributes(FluentComponent component, Map<String, Object> updated) {
        NestedAttributesMap existing = component.attributes();
        String deprecatedMessage = (String)updated.get("deprecated");
        if (deprecatedMessage != null) {
            if (!deprecatedMessage.equals(existing.get("deprecated"))) {
                component.withAttribute("deprecated", (Object)deprecatedMessage);
            }
        } else if (existing.get("deprecated") != null) {
            component.withoutAttribute("deprecated");
        }
    }
}

